/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.midi.playlist;

import io.github.tofodroid.mods.mimi.common.tile.TileTransmitter;
import io.github.tofodroid.mods.mimi.server.midi.playlist.APlaylistHandler;
import io.github.tofodroid.mods.mimi.server.midi.playlist.PlaylistData;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;

public class TileTransmitterPlaylistHandler
extends APlaylistHandler {
    private TileTransmitter tile;
    private PlaylistData data;

    public TileTransmitterPlaylistHandler(TileTransmitter tile) {
        super(tile.getUUID());
        this.tile = tile;
        this.refreshData();
    }

    @Override
    public ArrayList<UUID> getFavoriteSongs() {
        return this.data.favoriteSongs;
    }

    @Override
    public APlaylistHandler.LoopMode getLoopMode() {
        return this.data.loopMode;
    }

    @Override
    public APlaylistHandler.FavoriteMode getFavoriteMode() {
        return this.data.favoriteMode;
    }

    @Override
    public APlaylistHandler.SourceMode getSourceMode() {
        return APlaylistHandler.SourceMode.SERVER;
    }

    @Override
    public Boolean getIsShuffled() {
        return this.data.isShuffled;
    }

    @Override
    protected void setFavoriteSongs(ArrayList<UUID> favorites) {
        this.data.favoriteSongs = favorites;
        this.saveData();
    }

    @Override
    protected void setLoopMode(APlaylistHandler.LoopMode mode) {
        this.data.loopMode = mode;
        this.saveData();
    }

    @Override
    protected void setFavoriteMode(APlaylistHandler.FavoriteMode mode) {
        this.data.favoriteMode = mode;
        this.saveData();
    }

    @Override
    protected void setSourceMode(APlaylistHandler.SourceMode mode) {
    }

    @Override
    protected void setIsShuffled(Boolean shuffle) {
        this.data.isShuffled = shuffle;
        this.data.shuffleSeed = shuffle != false ? Integer.valueOf(Math.abs(new Random().nextInt())) : Integer.valueOf(0);
        this.saveData();
    }

    @Override
    public UUID getClientSourceId() {
        return null;
    }

    protected void saveData() {
        ItemStack sourceStack = this.tile.getSourceStack();
        PlaylistData.writeToTag(this.data, sourceStack.m_41784_());
        this.tile.setSourceStack(sourceStack);
        this.refreshData();
    }

    protected void refreshData() {
        this.data = PlaylistData.loadFromTag(this.tile.getSourceStack().m_41784_());
    }

    @Override
    protected Integer getShuffleSeed() {
        return this.data.shuffleSeed;
    }
}

