/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument;

import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerInventoryHolder;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastConsumer;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentHandheld;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.server.events.broadcast.consumer.instrument.InstrumentBroadcastConsumer;
import io.github.tofodroid.mods.mimi.util.EntityUtils;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntityInstrumentConsumerEventHandler {
    private static final List<InteractionHand> ENTITY_INSTRUMENT_ITER = Collections.unmodifiableList(Arrays.asList(InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND, null));

    public static void reloadEntityInstrumentConsumers(LivingEntity entity) {
        if (entity == null || entity.m_9236_() == null || !(entity.m_9236_() instanceof ServerLevel)) {
            return;
        }
        BroadcastConsumerInventoryHolder holder = new BroadcastConsumerInventoryHolder(entity.m_20148_());
        for (int i = 0; i < ENTITY_INSTRUMENT_ITER.size(); ++i) {
            ItemStack instrumentStack;
            InteractionHand hand = ENTITY_INSTRUMENT_ITER.get(i);
            ItemStack itemStack = instrumentStack = hand != null ? ItemInstrumentHandheld.getEntityHeldInstrumentStack(entity, hand) : BlockInstrument.getTileInstrumentStackForEntity(entity);
            if (instrumentStack == null || MidiNbtDataUtils.getMidiSource(instrumentStack) == null) continue;
            holder.putConsumer(i, new InstrumentBroadcastConsumer(() -> EntityUtils.getEntityHeadPos(entity), () -> entity.m_9236_().m_46472_(), entity.m_20148_(), instrumentStack, hand));
        }
        BroadcastManager.removeOwnedBroadcastConsumers(holder.getOwnerId());
        BroadcastManager.registerConsumers(holder);
    }

    public static void onLivingEquipmentChange(ItemStack from, ItemStack to, LivingEntity entity) {
        if (from.m_41720_() instanceof ItemInstrumentHandheld || to.m_41720_() instanceof ItemInstrumentHandheld) {
            EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers(entity);
        }
    }

    public static void onLivingDeath(LivingEntity entity) {
        EntityInstrumentConsumerEventHandler.allInstrumentConsumerNotesOff(entity.m_20148_());
    }

    public static void onEntityTeleport(Entity entity) {
        if (entity instanceof LivingEntity) {
            EntityInstrumentConsumerEventHandler.allInstrumentConsumerNotesOff(entity.m_20148_());
        }
    }

    public static void onEntityChangeDimension(Entity entity) {
        if (entity instanceof LivingEntity) {
            EntityInstrumentConsumerEventHandler.allInstrumentConsumerNotesOff(entity.m_20148_());
        }
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)player);
    }

    public static void onPlayerRespawn(ServerPlayer player) {
        EntityInstrumentConsumerEventHandler.reloadEntityInstrumentConsumers((LivingEntity)player);
    }

    public static void onPlayerLoggedOut(ServerPlayer player) {
        if (player.m_9236_() instanceof ServerLevel) {
            BroadcastManager.removeOwnedBroadcastConsumers(player.m_20148_());
        }
    }

    private static void allInstrumentConsumerNotesOff(UUID ownerId) {
        BroadcastConsumerInventoryHolder holder = BroadcastManager.getOwnedBroadcastConsumers(ownerId);
        if (holder != null) {
            for (IBroadcastConsumer consumer : holder.getConsumers()) {
                if (!(consumer instanceof InstrumentBroadcastConsumer)) continue;
                ((InstrumentBroadcastConsumer)consumer).sendReset();
            }
        }
    }
}

