/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.forge.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final String WORLD_CATEGORY_NAME = "World Generation";
    public static final String MOB_CATEGORY_NAME = "Mobs";
    public static final String OTHER_CATEGORY_NAME = "Other";
    public ForgeConfigSpec.BooleanValue enableInstrumentalistShop;
    public ForgeConfigSpec.BooleanValue doGiveBookOnFirstJoin;
    public ForgeConfigSpec.ConfigValue<String> allowedInstrumentMobs;
    public ForgeConfigSpec.BooleanValue doLogMidiTaskErrors;
    public ForgeConfigSpec.ConfigValue<Integer> midiTaskTimeoutMillis;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push(WORLD_CATEGORY_NAME);
        this.enableInstrumentalistShop = builder.comment("Toggles whether Instrumentalist shops should generate in villages.").translation("mimi.config.server.world.village.instrumentalist").define("enableInstrumentalistShop", true);
        this.allowedInstrumentMobs = builder.comment("Comma-separated list of mobs that can be given instruments to hold.").translation("mimi.config.server.mobs.allowed.instruments").define("allowedInstrumentMobs", (Object)"minecraft:zombie,minecraft:husk,minecraft:skeleton,minecraft:stray,minecraft:wither_skeleton");
        this.doGiveBookOnFirstJoin = builder.comment("Toggles wheter to give players the MIMI Guide Book on first join.").translation("mimi.config.server.world.guide").define("doGiveBookOnFirstJoin", true);
        builder.pop();
        builder.push(OTHER_CATEGORY_NAME);
        this.doLogMidiTaskErrors = builder.comment("Toggles whether MIMI should log when the server fails to timely execute a MIDI command which usually just indiciates server performance trouble.").translation("mimi.config.server.other.doLogMidiTaskErrors").define("doLogMidiTaskErrors", true);
        this.midiTaskTimeoutMillis = builder.comment("The number of milliseconds a MIDI thread task should wait before timing out. Longer times may reduce instances of tasks failing but also reduce responsiveness of Transmitters.").translation("mimi.config.server.other.midiTaskTimeoutMillis").define("midiTaskTimeoutMillis", (Object)15000);
    }
}

