/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.tile;

import io.github.tofodroid.mods.mimi.common.api.event.MidiEventType;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerInventoryHolder;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastConsumerMapping;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.BroadcastEvent;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastConsumer;
import io.github.tofodroid.mods.mimi.common.api.event.broadcast.IBroadcastProducer;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableMidiNoteResponsiveTile;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileRelay
extends AConfigurableMidiNoteResponsiveTile
implements IBroadcastProducer,
IBroadcastConsumer {
    public static final String REGISTRY_NAME = "relay";
    protected UUID linkedId;
    protected List<Byte> enabledChannelsList;
    protected Byte broadcastRange;
    protected Byte[] channelMap;
    protected BroadcastConsumerMapping consumerCache;

    public TileRelay(BlockPos pos, BlockState state) {
        super(ModTiles.RELAY, pos, state);
    }

    @Override
    protected void onFirstTick(ServerLevel world, BlockPos pos, BlockState state) {
        BroadcastManager.registerProducer(this);
    }

    @Override
    public void cacheMidiSettings() {
        UUID newLinkedId;
        super.cacheMidiSettings();
        if (this.m_58898_() && !this.m_58904_().f_46443_) {
            this.reset();
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
        this.linkedId = (newLinkedId = MidiNbtDataUtils.getMidiSource(this.getSourceStack())) != null && newLinkedId.toString().equals(this.getOwnerId().toString()) ? UUID.randomUUID() : newLinkedId;
        this.enabledChannelsList = MidiNbtDataUtils.getEnabledChannelsList(this.getSourceStack());
        this.broadcastRange = MidiNbtDataUtils.getBroadcastRange(this.getSourceStack());
        this.channelMap = MidiNbtDataUtils.getChannelMap(this.getSourceStack());
        if (this.m_58898_() && !this.m_58904_().f_46443_) {
            BroadcastConsumerInventoryHolder holder = new BroadcastConsumerInventoryHolder(this.getUUID());
            if (this.getLinkedId() != null) {
                holder.putConsumer(0, this);
            }
            BroadcastManager.registerConsumers(holder);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.m_58904_().m_5776_()) {
            this.reset();
            BroadcastManager.removeBroadcastProducer(this.getUUID());
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.m_58904_().m_5776_()) {
            this.reset();
            BroadcastManager.removeBroadcastProducer(this.getUUID());
            BroadcastManager.removeOwnedBroadcastConsumers(this.getUUID());
        }
    }

    @Override
    public void onNoteOn(Byte channel, Byte note, Byte velocity, Byte instrumentId, Long noteTime) {
        this.broadcast(this.mapEvent(MidiEventType.NOTE_ON, channel, note, velocity, noteTime));
    }

    @Override
    public void onNoteOff(Byte channel, Byte note, Byte velocity, Byte instrumentId, Long noteTime) {
        this.broadcast(this.mapEvent(MidiEventType.NOTE_OFF, channel, note, velocity, noteTime));
    }

    @Override
    public void onReset(Byte channel, Byte instrumentId, Long noteTime) {
        this.broadcast(BroadcastEvent.reset(channel, this.getUUID(), this.getBroadcastDimension(), this.getBroadcastPos(), noteTime));
    }

    public BroadcastEvent mapEvent(MidiEventType type, Byte channel, Byte note, Byte velocity, Long noteTime) {
        return this.mapEvent(type, channel, note, velocity, noteTime, null);
    }

    public BroadcastEvent mapEvent(MidiEventType type, Byte channel, Byte note, Byte velocity, Long noteTime, Integer extData) {
        BroadcastEvent event = new BroadcastEvent(type, channel == BroadcastEvent.ALL_CHANNELS ? BroadcastEvent.ALL_CHANNELS : this.channelMap[channel], note, velocity, this.getUUID(), this.getBroadcastDimension(), this.getBroadcastPos(), this.getBroadcastRange(), noteTime);
        return extData != null ? (BroadcastEvent)event.withExtData(extData) : event;
    }

    @Override
    public UUID getLinkedId() {
        return this.linkedId;
    }

    @Override
    public UUID getOwnerId() {
        return this.getUUID();
    }

    @Override
    public List<Byte> getEnabledChannelsList() {
        return this.enabledChannelsList;
    }

    @Override
    public Integer getBroadcastRange() {
        return this.broadcastRange != null ? 16 * this.broadcastRange : 64;
    }

    @Override
    public BlockPos getConsumePos() {
        return this.m_58899_();
    }

    @Override
    public ResourceKey<Level> getConsumeDimension() {
        return this.m_58904_().m_46472_();
    }

    @Override
    public BlockPos getBroadcastPos() {
        return this.m_58899_();
    }

    @Override
    public ResourceKey<Level> getBroadcastDimension() {
        return this.m_58904_().m_46472_();
    }

    @Override
    public void tickConsumer() {
    }

    @Override
    public void onConsumerRemoved() {
    }

    @Override
    public void close() throws Exception {
        this.onProducerRemoved();
        this.onConsumerRemoved();
    }

    @Override
    public void doHandleEvent(BroadcastEvent message) {
        this.broadcast(this.mapEvent(message.type, message.channel, message.note, message.velocity, message.eventTime, message.extData));
    }

    @Override
    public Boolean willHandleEvent(BroadcastEvent message) {
        return true;
    }

    @Override
    public BroadcastConsumerMapping getConsumers() {
        return this.consumerCache;
    }

    @Override
    public void linkConsumers(List<IBroadcastConsumer> consumers) {
        this.consumerCache = new BroadcastConsumerMapping(this.getUUID(), consumers);
    }

    @Override
    public void tickProducer() {
    }

    @Override
    public void onProducerRemoved() {
    }
}

