/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.recipe;

import io.github.tofodroid.mods.mimi.common.block.BlockEffectEmitter;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class CloneEffectEmitterRecipe
extends CustomRecipe {
    public static final String REGISTRY_NAME = "cloneeffectemitter";
    public static final List<Item> ITEMS = Arrays.asList(ModItems.EFFECTEMITTER);
    public static final SimpleCraftingRecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(CloneEffectEmitterRecipe::new);

    public CloneEffectEmitterRecipe(ResourceLocation recipeId, CraftingBookCategory category) {
        super(recipeId, category);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack source = ItemStack.f_41583_;
        Integer foundSlots = 1;
        List<Integer> validSlots = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackI = inv.m_8020_(i);
            if (!stackI.m_41619_() && !this.isValid(stackI).booleanValue()) {
                return false;
            }
            if (!stackI.m_41619_() && source.m_41619_()) {
                validSlots = this.getValidSlots(i, inv.m_39347_(), inv.m_39346_());
                if (validSlots != null) {
                    source = stackI;
                    continue;
                }
                return false;
            }
            if (source.m_41619_()) continue;
            if (validSlots.contains(i) && this.isValid(stackI).booleanValue()) {
                Integer n = foundSlots;
                foundSlots = foundSlots + 1;
                continue;
            }
            if (stackI.m_41619_() || validSlots.contains(i) && this.isValid(stackI).booleanValue()) continue;
            return false;
        }
        return !source.m_41619_() && foundSlots == 2;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess r) {
        ItemStack source = ItemStack.f_41583_;
        ItemStack target = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackI = inv.m_8020_(i);
            if (!stackI.m_41619_() && source.m_41619_()) {
                source = stackI;
                continue;
            }
            if (stackI.m_41619_() || source.m_41619_()) continue;
            target = stackI;
        }
        if (!source.m_41619_() && !target.m_41619_()) {
            return BlockEffectEmitter.copyEffectEmitterSettings(source, target);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            if (!this.isValid(inv.m_8020_(i)).booleanValue()) continue;
            nonnulllist.set(i, (Object)inv.m_8020_(i).m_255036_(1));
            break;
        }
        return nonnulllist;
    }

    protected Boolean isValid(ItemStack stack) {
        return ITEMS.contains(stack.m_41720_());
    }

    protected List<Integer> getValidSlots(Integer slot, Integer width, Integer height) {
        Integer slotCol = slot % height;
        if (slotCol < width - 1) {
            return Arrays.asList(slot, slot + 1);
        }
        return null;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

