/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.NetworkUtils;
import io.netty.handler.codec.DecoderException;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class SyncInstrumentPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("mimi", SyncInstrumentPacket.class.getSimpleName().toLowerCase());
    public final UUID midiSource;
    public final String midiSourceName;
    public final Integer enabledChannelsInt;
    public final Boolean sysInput;
    public final Byte volume;
    public final InteractionHand handIn;

    public SyncInstrumentPacket(UUID midiSource, String midiSourceName, Integer enabledChannelsInt, Boolean sysInput, Byte volume, InteractionHand handIn) {
        this.midiSource = midiSource;
        this.midiSourceName = midiSourceName;
        this.enabledChannelsInt = enabledChannelsInt;
        this.sysInput = sysInput;
        this.volume = volume;
        this.handIn = handIn;
    }

    public SyncInstrumentPacket(ItemStack instrumentStack, InteractionHand handIn) {
        this.midiSource = MidiNbtDataUtils.getMidiSource(instrumentStack);
        this.midiSourceName = MidiNbtDataUtils.getMidiSourceName(instrumentStack, false);
        this.enabledChannelsInt = MidiNbtDataUtils.getEnabledChannelsInt(instrumentStack);
        this.sysInput = MidiNbtDataUtils.getSysInput(instrumentStack);
        this.volume = MidiNbtDataUtils.getInstrumentVolume(instrumentStack);
        this.handIn = handIn;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        SyncInstrumentPacket.encodePacket(this, buf);
    }

    public static SyncInstrumentPacket decodePacket(FriendlyByteBuf buf) {
        try {
            UUID midiSource = null;
            if (buf.readBoolean()) {
                midiSource = buf.m_130259_();
            }
            String midiSourceName = null;
            if (buf.readBoolean()) {
                midiSourceName = buf.m_130136_(64);
            }
            Integer enabledChannelsInt = buf.readInt();
            Boolean sysInput = buf.readBoolean();
            Byte volume = buf.readByte();
            InteractionHand handIn = NetworkUtils.decodeHand(buf.readByte());
            return new SyncInstrumentPacket(midiSource, midiSourceName, enabledChannelsInt, sysInput, volume, handIn);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("SyncInstrumentPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
        catch (DecoderException e) {
            MIMIMod.LOGGER.error("SyncInstrumentPacket contained invalid bytes. Exception: " + String.valueOf((Object)e));
            return null;
        }
    }

    public static void encodePacket(SyncInstrumentPacket pkt, FriendlyByteBuf buf) {
        if (pkt.midiSource != null) {
            buf.writeBoolean(true);
            buf.m_130077_(pkt.midiSource);
        } else {
            buf.writeBoolean(false);
        }
        if (pkt.midiSourceName != null) {
            buf.writeBoolean(true);
            buf.m_130072_(pkt.midiSourceName, 64);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(pkt.enabledChannelsInt.intValue());
        buf.writeBoolean(pkt.sysInput.booleanValue());
        buf.writeByte((int)pkt.volume.byteValue());
        buf.writeByte((int)NetworkUtils.encodeHand(pkt.handIn).byteValue());
    }
}

