/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.network;

import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.midi.BasicMidiInfo;
import io.github.tofodroid.mods.mimi.common.network.CustomPacketPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ServerMusicPlayerSongListPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("mimi", ServerMusicPlayerSongListPacket.class.getSimpleName().toLowerCase());
    public static final Integer MAX_FILE_NAME_LENGTH = 200;
    public final UUID musicPlayerId;
    public final List<BasicMidiInfo> infos;
    public final List<Integer> favoriteIndicies;

    public ServerMusicPlayerSongListPacket(UUID musicPlayerId) {
        this.musicPlayerId = musicPlayerId;
        this.infos = new ArrayList<BasicMidiInfo>();
        this.favoriteIndicies = new ArrayList<Integer>();
    }

    public ServerMusicPlayerSongListPacket(UUID musicPlayerId, List<BasicMidiInfo> infos, List<Integer> favoriteIndicies) {
        this.musicPlayerId = musicPlayerId;
        this.favoriteIndicies = favoriteIndicies;
        if (infos.size() > 1000) {
            MIMIMod.LOGGER.warn("ServerMusicPlayerSongListPacket can only accept up to 1000 files. Trimming list ot 1000.");
            this.infos = new ArrayList<BasicMidiInfo>(infos).subList(0, 1000);
        } else {
            this.infos = infos;
        }
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        ServerMusicPlayerSongListPacket.encodePacket(this, buf);
    }

    public static ServerMusicPlayerSongListPacket decodePacket(FriendlyByteBuf buf) {
        try {
            int i;
            UUID musicPlayerId = buf.m_130259_();
            int numFavorites = buf.readByte();
            int numInfos = buf.readByte();
            ArrayList<Integer> decodeFavorites = new ArrayList<Integer>();
            ArrayList<BasicMidiInfo> decodeInfos = new ArrayList<BasicMidiInfo>();
            for (i = 0; i < numFavorites; ++i) {
                decodeFavorites.add(Integer.valueOf(buf.readByte()));
            }
            for (i = 0; i < numInfos; ++i) {
                decodeInfos.add(new BasicMidiInfo(buf.m_130136_(MAX_FILE_NAME_LENGTH.intValue()), buf.m_130259_(), buf.readBoolean()));
            }
            return new ServerMusicPlayerSongListPacket(musicPlayerId, decodeInfos, decodeFavorites);
        }
        catch (IndexOutOfBoundsException e) {
            MIMIMod.LOGGER.error("ServerMusicPlayerSongListPacket did not contain enough bytes. Exception: " + String.valueOf(e));
            return null;
        }
    }

    public static void encodePacket(ServerMusicPlayerSongListPacket pkt, FriendlyByteBuf buf) {
        int i;
        buf.m_130077_(pkt.musicPlayerId);
        buf.writeByte(pkt.favoriteIndicies.size());
        buf.writeByte(pkt.infos.size());
        for (i = 0; i < pkt.favoriteIndicies.size(); ++i) {
            buf.writeByte((int)pkt.favoriteIndicies.get(i).byteValue());
        }
        for (i = 0; i < pkt.infos.size(); ++i) {
            buf.m_130072_(pkt.infos.get((int)i).fileName, MAX_FILE_NAME_LENGTH.intValue());
            buf.m_130077_(pkt.infos.get((int)i).fileId);
            buf.writeBoolean(pkt.infos.get((int)i).serverMidi.booleanValue());
        }
    }
}

