/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.block.ModBlocks;
import io.github.tofodroid.mods.mimi.common.tile.AConfigurableTile;
import io.github.tofodroid.mods.mimi.common.tile.TileRelay;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSourceLinker
extends Item {
    public static final String REGISTRY_NAME = "sourcelinker";

    public ItemSourceLinker(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        if (MidiNbtDataUtils.getMidiSource(stack) == null) {
            tooltip.add((Component)Component.m_237113_((String)"Crouch + Right-Click to Link to a Transmitter").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Right-Click Block to Link it to Saved Transmitter").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        MidiNbtDataUtils.appendMidiSourceTooltip(stack, tooltip);
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity target, InteractionHand handIn) {
        if (target instanceof Player && user.m_6047_()) {
            if (!user.m_9236_().f_46443_) {
                MidiNbtDataUtils.setMidiSource(stack, target.m_20148_(), target.m_7755_().getString());
                user.m_21008_(handIn, stack);
                MutableComponent message = Component.m_237113_((String)"Linked ").m_7220_(stack.m_41786_()).m_7220_((Component)Component.m_237113_((String)" to ")).m_7220_(target.m_7755_());
                user.m_5661_((Component)message, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (playerIn.m_6047_()) {
            if (!worldIn.f_46443_) {
                MidiNbtDataUtils.setMidiSource(heldItem, playerIn.m_20148_(), playerIn.m_7755_().getString());
                playerIn.m_21008_(handIn, heldItem);
                MutableComponent message = Component.m_237113_((String)"Linked ").m_7220_(heldItem.m_41786_()).m_7220_((Component)Component.m_237113_((String)" to ")).m_7220_(playerIn.m_7755_());
                playerIn.m_5661_((Component)message, true);
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19098_((Object)heldItem);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        Block block = level.m_8055_(pos).m_60734_();
        return block.equals((Object)ModBlocks.TRANSMITTERBLOCK) || block.equals((Object)ModBlocks.RELAY);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack heldItem = context.m_43722_();
        UUID savedSource = MidiNbtDataUtils.getMidiSource(heldItem);
        if (!context.m_7078_() && savedSource != null) {
            String savedSourceName = MidiNbtDataUtils.getMidiSourceName(heldItem, false);
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            if (state.m_60734_() instanceof BlockInstrument || state.m_60734_().equals((Object)ModBlocks.RECEIVER) || state.m_60734_().equals((Object)ModBlocks.RELAY)) {
                AConfigurableTile tile;
                if (!(context.m_43725_().f_46443_ || (tile = (AConfigurableTile)((Object)((AConfigurableTileBlock)state.m_60734_()).getTileForBlock(context.m_43725_(), context.m_8083_()))) == null || tile instanceof TileRelay && ((TileRelay)tile).getUUID().equals(savedSource))) {
                    ItemStack sourceStack = tile.getSourceStack();
                    MidiNbtDataUtils.setMidiSource(sourceStack, savedSource, savedSourceName);
                    tile.setSourceStack(sourceStack);
                    MutableComponent message = Component.m_237113_((String)"Linked ").m_7220_((Component)state.m_60734_().m_49954_()).m_7220_((Component)Component.m_237113_((String)" to configured ")).m_7220_(MidiNbtDataUtils.getMidiSourceType(heldItem));
                    context.m_43723_().m_5661_((Component)message, true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

