/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface IColorableItem
extends DyeableLeatherItem {
    public static final Integer DEFAULT_WHITE_COLOR = -1;

    public Boolean isColorable();

    public Integer getDefaultColor();

    default public boolean hasColor(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        return this.isColorable() != false && compoundnbt != null && compoundnbt.m_128425_("color", 99);
    }

    default public int m_41121_(ItemStack stack) {
        if (!this.isColorable().booleanValue()) {
            return -1;
        }
        CompoundTag compoundnbt = stack.m_41737_("display");
        return compoundnbt != null && compoundnbt.m_128425_("color", 99) ? compoundnbt.m_128451_("color") : this.getDefaultColor().intValue();
    }

    default public void removeColor(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        if (this.isColorable().booleanValue() && compoundnbt != null && compoundnbt.m_128441_("color")) {
            compoundnbt.m_128473_("color");
        }
    }

    default public void m_41115_(ItemStack stack, int color) {
        if (this.isColorable().booleanValue() && color >= 0) {
            IColorableItem.saveColorToTag(stack.m_41784_(), color);
        }
    }

    public static void saveColorToTag(CompoundTag tag, int color) {
        if (color >= 0) {
            CompoundTag colorT = new CompoundTag();
            colorT.m_128405_("color", color);
            tag.m_128365_("display", (Tag)colorT);
        }
    }

    default public Boolean washItem(UseOnContext context) {
        if (!context.m_43723_().m_6047_() && ((IColorableItem)context.m_43722_().m_41720_()).hasColor(context.m_43722_()) && context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof LayeredCauldronBlock) {
            if (context.m_43723_() instanceof ServerPlayer) {
                ((IColorableItem)context.m_43722_().m_41720_()).m_41123_(context.m_43722_());
                LayeredCauldronBlock.m_153559_((BlockState)context.m_43725_().m_8055_(context.m_8083_()), (Level)context.m_43725_(), (BlockPos)context.m_8083_());
            }
            return true;
        }
        return false;
    }

    public static Boolean isDyeableInstrument(ItemStack stack) {
        return stack.m_41720_() instanceof IColorableItem && ((IColorableItem)stack.m_41720_()).isColorable() != false;
    }

    public static ItemStack dyeItem(ItemStack stack, List<DyeItem> dyes) {
        return DyeableLeatherItem.m_41118_((ItemStack)stack, dyes);
    }
}

