/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableNoteResponsiveTileBlock;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.item.IInstrumentItem;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileReceiver;
import io.github.tofodroid.mods.mimi.common.tile.TileRelay;
import io.github.tofodroid.mods.mimi.server.events.broadcast.BroadcastManager;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockRelay
extends AConfigurableNoteResponsiveTileBlock<TileRelay> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final String REGISTRY_NAME = "relay";

    public BlockRelay(BlockBehaviour.Properties props) {
        super(props.m_155956_(6.0f).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60924_((a, b, c) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{POWERED});
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openRelayGui;
    }

    @Override
    public BlockEntityType<TileRelay> getTileType() {
        return ModTiles.RELAY;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        TileRelay tile = (TileRelay)this.getTileForBlock(level, pos);
        if ((stack.m_41720_() instanceof IInstrumentItem || stack.m_41720_().equals(ModItems.RECEIVER) || stack.m_41720_().equals(ModItems.RELAY) || stack.m_41720_().equals((Object)ModItems.SOURCELINKER)) && tile != null && player.m_6047_()) {
            if (!level.f_46443_) {
                String transmitterName = level.m_46472_().m_135782_().m_135815_() + "@(" + pos.m_123344_() + ")";
                MidiNbtDataUtils.setMidiSourceFromRelay(stack, tile.getUUID(), transmitterName);
                player.m_21008_(player.m_7655_(), stack);
                MutableComponent message = Component.m_237113_((String)"Linked ").m_7220_(stack.m_41786_()).m_7220_((Component)Component.m_237113_((String)" to ")).m_7220_((Component)this.m_49954_());
                player.m_5661_((Component)message, true);
            }
            return InteractionResult.SUCCESS;
        }
        if (tile != null && !this.shouldSkipUse(state, level, pos, player, hand).booleanValue() && level.f_46443_) {
            ClientGuiWrapper.openRelayGui(level, player, pos, null, tile.getSourceStack());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_) {
            if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
                return;
            }
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof TileReceiver) {
                BroadcastManager.removeOwnedBroadcastConsumers(((TileReceiver)blockEntity).getUUID());
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Override
    protected Boolean shouldSkipUse(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand) {
        Item useItem = player.m_21120_(hand).m_41720_();
        return useItem.equals((Object)ModItems.SETTINGSSYNC) || useItem.equals((Object)ModItems.SOURCELINKER);
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"MIDI Settings:").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        MidiNbtDataUtils.appendBroadcastRangeTooltip(blockItemStack, tooltip);
        MidiNbtDataUtils.appendMidiChannelMappingsTooltip(blockItemStack, tooltip);
        MidiNbtDataUtils.appendMidiSourceTooltip(blockItemStack, tooltip);
    }
}

