/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.client.gui.ClientGuiWrapper;
import io.github.tofodroid.mods.mimi.common.block.AConfigurableTileBlock;
import io.github.tofodroid.mods.mimi.common.item.ModItems;
import io.github.tofodroid.mods.mimi.common.tile.ModTiles;
import io.github.tofodroid.mods.mimi.common.tile.TileEffectEmitter;
import io.github.tofodroid.mods.mimi.util.TagUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEffectEmitter
extends AConfigurableTileBlock<TileEffectEmitter> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;
    public static final String REGISTRY_NAME = "effectemitter";

    public BlockEffectEmitter(BlockBehaviour.Properties props) {
        super(props.m_155956_(6.0f).m_60978_(2.0f).m_60918_(SoundType.f_154663_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)INVERTED, (Comparable)TagUtils.getBooleanOrDefault(context.m_43722_(), "invert_signal", false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    @Override
    public BlockEntityType<TileEffectEmitter> getTileType() {
        return ModTiles.EFFECTEMITTER;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{INVERTED});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockEffectEmitter.m_152132_(type, this.getTileType(), TileEffectEmitter::doTick);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Boolean wasPowered;
        if (!worldIn.f_46443_ && (wasPowered = (Boolean)state.m_61143_((Property)POWERED)).booleanValue() != worldIn.m_276867_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    @Override
    public AConfigurableTileBlock.OpenGuiWrapper openGuiWrapper() {
        return ClientGuiWrapper::openEffectEmitterGui;
    }

    @Override
    protected void appendSettingsTooltip(ItemStack blockItemStack, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"Effect Settings:").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237113_((String)"Inverted:").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237113_((String)("  " + (TagUtils.getBooleanOrDefault(blockItemStack, "invert_signal", false) != false ? "Yes" : "No"))).m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237113_((String)"Sound:").m_130940_(ChatFormatting.GREEN));
        String soundResource = TagUtils.getStringOrDefault(blockItemStack, "sound", "");
        if (soundResource.isBlank()) {
            tooltip.add((Component)Component.m_237113_((String)"  None").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237113_((String)("  ID: " + soundResource)).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)("  Volume: " + TagUtils.getByteOrDefault(blockItemStack, "volume", 5))).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)("  Pitch: " + TagUtils.getByteOrDefault(blockItemStack, "pitch", 0))).m_130940_(ChatFormatting.GREEN));
            Integer loop = TagUtils.getIntOrDefault(blockItemStack, "sound_loop", 0);
            tooltip.add((Component)Component.m_237113_((String)(loop == 0 ? "  Loop: None" : "  Loop: Every " + loop + " ticks")).m_130940_(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.m_237113_((String)"Particle:").m_130940_(ChatFormatting.GREEN));
        String particleResource = TagUtils.getStringOrDefault(blockItemStack, "particle", "");
        if (particleResource.isBlank()) {
            tooltip.add((Component)Component.m_237113_((String)"  None").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)Component.m_237113_((String)("  ID: " + particleResource)).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)("  Side: " + BlockEffectEmitter.getSideFromByte(TagUtils.getByteOrDefault(blockItemStack, "side", 0)))).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)"  Speed: ").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)("    X: " + TagUtils.getByteOrDefault(blockItemStack, "speed_x", 0) + ", Y: " + TagUtils.getByteOrDefault(blockItemStack, "speed_y", 0) + ", Z: " + TagUtils.getByteOrDefault(blockItemStack, "speed_z", 0))).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)("  Area: " + TagUtils.getByteOrDefault(blockItemStack, "spread", 0))).m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)("  Num: " + TagUtils.getByteOrDefault(blockItemStack, "count", 0))).m_130940_(ChatFormatting.GREEN));
            Integer loop = TagUtils.getIntOrDefault(blockItemStack, "particle_loop", 0);
            tooltip.add((Component)Component.m_237113_((String)(loop == 0 ? "  Loop: None" : "  Loop: Every " + loop + " ticks")).m_130940_(ChatFormatting.GREEN));
        }
    }

    public static String getSideFromByte(Byte side) {
        switch (side) {
            default: {
                return "Top";
            }
            case 1: {
                return "Bottom";
            }
            case 2: {
                return "North";
            }
            case 3: {
                return "East";
            }
            case 4: {
                return "South";
            }
            case 5: 
        }
        return "West";
    }

    public static ItemStack copyEffectEmitterSettings(ItemStack source, ItemStack target) {
        if (!source.m_41619_() && !target.m_41619_()) {
            ItemStack result = target.m_255036_(1);
            TagUtils.setOrRemoveString(result, "sound", TagUtils.getStringOrDefault(source, "sound", ""));
            TagUtils.setOrRemoveString(result, "particle", TagUtils.getStringOrDefault(source, "particle", ""));
            TagUtils.setOrRemoveByte(result, "volume", TagUtils.getByteOrDefault(source, "volume", 5));
            TagUtils.setOrRemoveByte(result, "pitch", TagUtils.getByteOrDefault(source, "pitch", 0));
            TagUtils.setOrRemoveByte(result, "side", TagUtils.getByteOrDefault(source, "side", 0));
            TagUtils.setOrRemoveByte(result, "spread", TagUtils.getByteOrDefault(source, "spread", 0));
            TagUtils.setOrRemoveByte(result, "count", TagUtils.getByteOrDefault(source, "count", 1));
            TagUtils.setOrRemoveByte(result, "speed_x", TagUtils.getByteOrDefault(source, "speed_x", 0));
            TagUtils.setOrRemoveByte(result, "speed_y", TagUtils.getByteOrDefault(source, "speed_y", 0));
            TagUtils.setOrRemoveByte(result, "speed_z", TagUtils.getByteOrDefault(source, "speed_z", 0));
            TagUtils.setOrRemoveInt(result, "sound_loop", TagUtils.getIntOrDefault(source, "sound_loop", 0));
            TagUtils.setOrRemoveInt(result, "particle_loop", TagUtils.getIntOrDefault(source, "particle_loop", 0));
            TagUtils.setOrRemoveBoolean(result, "invert_signal", TagUtils.getBooleanOrDefault(source, "invert_signal", false));
            return result;
        }
        return target;
    }

    @Override
    protected Boolean shouldSkipUse(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand) {
        Item useItem = player.m_21120_(hand).m_41720_();
        return useItem.equals((Object)ModItems.SETTINGSSYNC);
    }
}

