/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.common.block;

import io.github.tofodroid.mods.mimi.common.tile.AContainerTile;
import io.github.tofodroid.mods.mimi.common.tile.AStaticInventoryTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AContainerBlock<T extends BlockEntity>
extends BaseEntityBlock {
    protected AContainerBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        this.dropContent(worldIn, pos, worldIn.m_7702_(pos));
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        T tile;
        if (!worldIn.f_46443_ && (tile = this.getTileForBlock(worldIn, pos)) != null) {
            player.m_5893_(this.m_7246_(state, worldIn, pos));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.getTileType().m_155264_(pos, state);
    }

    public abstract BlockEntityType<T> getTileType();

    public void writeGuiFriendlyByteBuf(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, FriendlyByteBuf buffer) {
        buffer.m_130064_(pos);
    }

    public void dropContent(Level worldIn, BlockPos pos, BlockEntity blockEntity) {
        if (blockEntity instanceof AContainerTile) {
            ((AContainerTile)blockEntity).dropContent();
            worldIn.m_46717_(pos, (Block)this);
        } else if (blockEntity instanceof AStaticInventoryTile) {
            ((AStaticInventoryTile)blockEntity).dropContent();
            worldIn.m_46717_(pos, (Block)this);
        }
    }

    public T getTileForBlock(Level worldIn, BlockPos pos) {
        BlockEntity entity = worldIn.m_7702_(pos);
        return (T)(entity != null && entity instanceof BlockEntity && entity instanceof Container ? entity : null);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }
}

