/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import io.github.tofodroid.com.sun.media.sound.SF2SoundbankReader;
import io.github.tofodroid.mods.mimi.client.gui.GuiInstrument;
import io.github.tofodroid.mods.mimi.client.midi.AudioOutputDeviceManager;
import io.github.tofodroid.mods.mimi.client.midi.synth.AMIMISynth;
import io.github.tofodroid.mods.mimi.client.midi.synth.BroadcastedNoteMIMISynth;
import io.github.tofodroid.mods.mimi.client.midi.synth.LocalNoteMIMISynth;
import io.github.tofodroid.mods.mimi.common.MIMIMod;
import io.github.tofodroid.mods.mimi.common.config.ConfigProxy;
import io.github.tofodroid.mods.mimi.common.network.NetworkProxy;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.network.ServerTimeSyncPacket;
import io.github.tofodroid.mods.mimi.util.TimeUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class MidiMultiSynthManager {
    private static final Integer MIDI_TICK_FREQUENCY = 2;
    protected Boolean loggingOff = false;
    protected Boolean paused = false;
    protected Boolean dead = false;
    protected Soundbank soundbank = null;
    protected Integer midiTickCounter = 0;
    public AudioOutputDeviceManager audioDeviceManager = new AudioOutputDeviceManager();
    protected LocalNoteMIMISynth localSynth;
    protected BroadcastedNoteMIMISynth networkSynth;

    public MidiMultiSynthManager() {
        this.soundbank = this.openSoundbank(ConfigProxy.getSoundfontPath());
        if (this.soundbank != null) {
            MIMIMod.LOGGER.debug("Loaded Soundbank:\n\n\tName: " + this.soundbank.getName() + "\n\tDesc: " + this.soundbank.getDescription() + "\n\tVers: " + this.soundbank.getVersion() + "\n\tVend: " + this.soundbank.getVendor() + "\n");
        }
    }

    public void handleClientTick() {
        Integer n = this.midiTickCounter;
        this.midiTickCounter = this.midiTickCounter + 1;
        Boolean gamePaused = Minecraft.m_91087_().m_91104_();
        if (!this.paused.booleanValue() && gamePaused.booleanValue()) {
            this.reset();
            this.paused = true;
        } else if (this.paused.booleanValue() && !gamePaused.booleanValue()) {
            this.paused = false;
        }
        if (this.midiTickCounter >= MIDI_TICK_FREQUENCY && Minecraft.m_91087_().f_91074_ != null) {
            this.localSynth.tick((Player)Minecraft.m_91087_().f_91074_);
            this.networkSynth.tick((Player)Minecraft.m_91087_().f_91074_);
        }
    }

    public void handleLogout() {
        this.close();
        this.loggingOff = true;
        this.dead = true;
    }

    public void handleLogin() {
        this.loggingOff = false;
        this.dead = false;
        this.reloadSynths();
        NetworkProxy.sendToServer(new ServerTimeSyncPacket());
    }

    public void reloadSynths() {
        if (this.localSynth != null) {
            this.localSynth.close();
        }
        if (this.networkSynth != null) {
            this.networkSynth.close();
        }
        Pair<AudioFormat, SourceDataLine> netOutLine = this.audioDeviceManager.getOutputFormatLine();
        this.networkSynth = new BroadcastedNoteMIMISynth((AudioFormat)netOutLine.getLeft(), (SourceDataLine)netOutLine.getRight(), ConfigProxy.getJitterCorrection(), ConfigProxy.getLatency(), this.soundbank);
        Pair<AudioFormat, SourceDataLine> localOutLine = this.audioDeviceManager.getOutputFormatLine();
        this.localSynth = new LocalNoteMIMISynth((AudioFormat)localOutLine.getLeft(), (SourceDataLine)localOutLine.getRight(), ConfigProxy.getLocalJitterCorrection(), ConfigProxy.getLocalLatency(), this.soundbank);
    }

    public Long getBufferTime(Long noteServerTime) {
        return MIMIMod.getProxy().getBaselineBufferMs() + (long)(Minecraft.m_91087_().m_91089_() != null ? ConfigProxy.getLocalBufferms() : 0) + (MIMIMod.getProxy().getServerStartEpoch() + noteServerTime);
    }

    public void close() {
        if (this.localSynth != null) {
            this.localSynth.reset();
            this.localSynth.close();
        }
        if (this.networkSynth != null) {
            this.networkSynth.reset();
            this.networkSynth.close();
        }
    }

    public void sendToGui(NoteEventPacket message) {
        if (Minecraft.m_91087_().f_91074_ == null || !message.player.equals(Minecraft.m_91087_().f_91074_.m_20148_()) || Minecraft.m_91087_().f_91080_ == null || !(Minecraft.m_91087_().f_91080_ instanceof GuiInstrument)) {
            return;
        }
        GuiInstrument gui = (GuiInstrument)Minecraft.m_91087_().f_91080_;
        if (message.instrumentId == gui.getInstrumentId() && message.instrumentHand == gui.getHandIn()) {
            if (message.data2 > 0) {
                gui.onExternalNotePress(message.data1);
            } else {
                gui.onExternalNoteRelease(message.data1);
            }
        }
    }

    public void handlePacket(NoteEventPacket message) {
        this.handleEventOnSynth(message, this.networkSynth, this.getBufferTime(message.noteServerTime));
    }

    public void handleLocalPacketInstant(NoteEventPacket message) {
        this.handleEventOnSynth(message, this.localSynth, TimeUtils.getNowTime());
    }

    private void handleEventOnSynth(NoteEventPacket message, AMIMISynth<?> synth, Long timestamp) {
        if (this.loggingOff.booleanValue() || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (synth != null && !Minecraft.m_91087_().m_91104_()) {
            switch (message.type) {
                case NOTE_ON: {
                    synth.noteOn(message, timestamp);
                    this.sendToGui(message);
                    break;
                }
                case NOTE_OFF: {
                    synth.noteOff(message, timestamp);
                    this.sendToGui(message);
                    break;
                }
                case RESET: {
                    synth.reset();
                    break;
                }
                case CONTROL: {
                    synth.controlChange(message, timestamp);
                    break;
                }
                case PITCH_BEND: {
                    synth.pitchBend(message, timestamp);
                }
            }
        } else if (Minecraft.m_91087_().m_91104_()) {
            synth.reset();
        }
    }

    public void handlePlayerTick(Player player) {
        if (player.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            if (!player.m_6084_() && !this.dead.booleanValue()) {
                this.reset();
            } else {
                this.dead = !player.m_6084_();
            }
        }
    }

    public void reset() {
        if (this.localSynth != null) {
            this.localSynth.reset();
        }
        if (this.networkSynth != null) {
            this.networkSynth.reset();
        }
    }

    protected Soundbank openSoundbank(String resourcePath) {
        if (resourcePath != null && !resourcePath.trim().isEmpty()) {
            try {
                return new SF2SoundbankReader().getSoundbank(new BufferedInputStream(new FileInputStream(new File(resourcePath.trim()))));
            }
            catch (IOException | NullPointerException | InvalidMidiDataException e) {
                MIMIMod.LOGGER.warn("Failed to load user SoundFont. Error: ", (Throwable)e);
            }
        }
        try {
            return new SF2SoundbankReader().getSoundbank(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("assets/mimi/soundfont/GMGSX.SF2")));
        }
        catch (IOException | NullPointerException | InvalidMidiDataException e) {
            MIMIMod.LOGGER.error("Failed to load MIMI SoundFont. Error: ", (Throwable)e);
            return null;
        }
    }
}

