/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.midi.synth;

import io.github.tofodroid.com.sun.media.sound.SoftChannelProxy;
import io.github.tofodroid.mods.mimi.client.midi.synth.AMIMISynth;
import io.github.tofodroid.mods.mimi.client.midi.synth.MIMIChannel;
import io.github.tofodroid.mods.mimi.client.midi.synth.MIMISynthUtils;
import io.github.tofodroid.mods.mimi.common.block.BlockInstrument;
import io.github.tofodroid.mods.mimi.common.item.ItemInstrumentHandheld;
import io.github.tofodroid.mods.mimi.common.network.NoteEventPacket;
import io.github.tofodroid.mods.mimi.common.tile.TileInstrument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sound.midi.Soundbank;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class LocalNoteMIMISynth
extends AMIMISynth<MIMIChannel> {
    public LocalNoteMIMISynth(AudioFormat format, SourceDataLine dataLine, Boolean jitterCorrection, Integer latency, Soundbank sounds) {
        super(format, dataLine, jitterCorrection, latency, sounds);
    }

    @Override
    public Boolean tick(Player clientPlayer) {
        if (this.internalSynth != null && !this.channelAssignmentMap.isEmpty()) {
            ArrayList<MIMIChannel> toRemove = new ArrayList<MIMIChannel>();
            TileInstrument instrumentTile = BlockInstrument.getTileInstrumentForEntity((LivingEntity)clientPlayer);
            List<Byte> playerInstruments = Arrays.asList(ItemInstrumentHandheld.getEntityHeldInstrumentId((LivingEntity)clientPlayer, InteractionHand.MAIN_HAND), ItemInstrumentHandheld.getEntityHeldInstrumentId((LivingEntity)clientPlayer, InteractionHand.OFF_HAND), instrumentTile != null ? instrumentTile.getInstrumentId() : null);
            for (Map.Entry entry : this.channelAssignmentMap.entrySet()) {
                Byte instrumentId = this.getInstrumentIdFromChannelId((String)entry.getValue());
                if (!((MIMIChannel)entry.getKey()).tick(clientPlayer, true).booleanValue() || instrumentId == null || !playerInstruments.contains(instrumentId)) {
                    toRemove.add((MIMIChannel)entry.getKey());
                    continue;
                }
                ((MIMIChannel)entry.getKey()).setVolume(MIMISynthUtils.getVolumeForRelativeNoteDistance(0.0));
            }
            for (MIMIChannel remove : toRemove) {
                this.channelAssignmentMap.remove((Object)remove);
                remove.clear();
            }
            return true;
        }
        return false;
    }

    @Override
    protected MIMIChannel createChannel(Integer num, SoftChannelProxy channel) {
        return new MIMIChannel(num, channel);
    }

    @Override
    protected String createChannelId(NoteEventPacket message) {
        return message.instrumentId.toString() + "$" + message.channel.toString();
    }

    protected Byte getInstrumentIdFromChannelId(String channelId) {
        return Byte.valueOf(channelId.substring(0, channelId.indexOf("$")));
    }

    protected Byte getChannelFromChannelId(String channelId) {
        return Byte.valueOf(channelId.substring(channelId.indexOf("$") + 1));
    }
}

