/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.client.gui.widget.BaseWidget;
import io.github.tofodroid.mods.mimi.util.MidiNbtDataUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class HoldTicksWidget
extends BaseWidget {
    private static final Vector2Int DOWN_BUTTON_COORDS = new Vector2Int(58, 3);
    private static final Vector2Int UP_BUTTON_COORDS = new Vector2Int(98, 3);
    private static final Vector2Int VALUE_TEXT_COORDS = new Vector2Int(78, 7);
    private ItemStack midiStack;

    public HoldTicksWidget(ItemStack midiStack, Vector2Int screenOffset, Vector2Int start) {
        super("textures/gui/widget/hold_ticks.png", 116, new Vector2Int(116, 21), screenOffset, start);
        this.midiStack = midiStack;
    }

    @Override
    public void renderGraphics(GuiGraphics graphics, Integer mouseX, Integer mouseY) {
        super.renderGraphics(graphics, mouseX, mouseY);
    }

    @Override
    public void renderText(GuiGraphics graphics, Font font, Integer mouseX, Integer mouseY) {
        super.renderText(graphics, font, mouseX, mouseY);
        this.drawStringAbsolute(graphics, font, MidiNbtDataUtils.getHoldTicks(this.midiStack).toString(), this.ABSOLUTE_START.x() + HoldTicksWidget.VALUE_TEXT_COORDS.x, this.ABSOLUTE_START.y() + HoldTicksWidget.VALUE_TEXT_COORDS.y, -16718336);
    }

    @Override
    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), DOWN_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setHoldTicks(this.midiStack, Integer.valueOf(MidiNbtDataUtils.getHoldTicks(this.midiStack) - 1).byteValue());
            return true;
        }
        if (CommonGuiUtils.clickedBox(localMouseCoords.x(), localMouseCoords.y(), UP_BUTTON_COORDS).booleanValue()) {
            MidiNbtDataUtils.setHoldTicks(this.midiStack, Integer.valueOf(MidiNbtDataUtils.getHoldTicks(this.midiStack) + 1).byteValue());
            return true;
        }
        return false;
    }
}

