/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui.widget;

import io.github.tofodroid.mods.mimi.client.gui.CommonGuiUtils;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public abstract class BaseWidget {
    protected final ResourceLocation GUI_TEXTURE;
    protected final Integer TEXTURE_SIZE;
    protected final Vector2Int GUI_START;
    protected final Vector2Int WIDGET_START;
    protected final Vector2Int ABSOLUTE_START;
    protected final Vector2Int WIDGET_SIZE;

    public BaseWidget(String textureResource, Integer textureSize, Vector2Int size, Vector2Int guiStartOffset, Vector2Int start) {
        this.GUI_TEXTURE = new ResourceLocation("mimi", textureResource);
        this.TEXTURE_SIZE = textureSize;
        this.GUI_START = guiStartOffset;
        this.WIDGET_START = start;
        this.WIDGET_SIZE = size;
        this.ABSOLUTE_START = new Vector2Int(this.GUI_START.x() + this.WIDGET_START.x(), this.GUI_START.y() + this.WIDGET_START.y());
    }

    public void renderGraphics(GuiGraphics graphics, Integer mouseX, Integer mouseY) {
        this.blitAbsolute(graphics, this.GUI_TEXTURE, this.ABSOLUTE_START.x(), this.ABSOLUTE_START.y(), 0.0f, 0.0f, this.WIDGET_SIZE.x(), this.WIDGET_SIZE.y(), this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    public final Boolean mouseClicked(Integer mouseX, Integer mouseY, Integer mouseButton) {
        return this.mouseClicked(this.screenToLocalCoords(new Vector2Int(mouseX, mouseY)), mouseButton);
    }

    public void renderText(GuiGraphics graphics, Font font, Integer mouseX, Integer mouseY) {
    }

    public Boolean keyPressed(Integer keyCode, Integer scanCode, Integer modifiers) {
        return false;
    }

    protected Boolean mouseClicked(Vector2Int localMouseCoords, Integer mouseButton) {
        return false;
    }

    protected Vector2Int screenToLocalCoords(Vector2Int screenCoords) {
        return new Vector2Int(screenCoords.x() - this.ABSOLUTE_START.x(), screenCoords.y() - this.ABSOLUTE_START.y());
    }

    protected Vector2Int localToScreenCoords(Vector2Int localCoords) {
        return new Vector2Int(localCoords.x() + this.ABSOLUTE_START.x(), localCoords.y() + this.ABSOLUTE_START.y());
    }

    protected void blitAbsolute(GuiGraphics graphics, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        CommonGuiUtils.blitAbsolute(graphics, this.GUI_TEXTURE, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    protected void blitAbsolute(GuiGraphics graphics, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY) {
        CommonGuiUtils.blitAbsolute(graphics, this.GUI_TEXTURE, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    protected void blitAbsolute(GuiGraphics graphics, ResourceLocation texture, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        CommonGuiUtils.blitAbsolute(graphics, texture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    protected void blitAbsolute(GuiGraphics graphics, ResourceLocation texture, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY) {
        CommonGuiUtils.blitAbsolute(graphics, texture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, this.TEXTURE_SIZE, this.TEXTURE_SIZE);
    }

    protected void drawStringAbsolute(GuiGraphics graphics, Font font, String string, Integer renderStartX, Integer renderStartY, Integer color) {
        CommonGuiUtils.drawStringAbsolute(graphics, font, string, renderStartX, renderStartY, color);
    }
}

