/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.mods.mimi.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import io.github.tofodroid.mods.mimi.util.Vector2Int;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public abstract class CommonGuiUtils {
    public static final Integer STANDARD_BUTTON_SIZE = 15;

    public static final Boolean clickedBox(Integer mouseX, Integer mouseY, Vector2Int buttonPos) {
        return CommonGuiUtils.clickedBox(mouseX, mouseY, buttonPos, new Vector2Int(STANDARD_BUTTON_SIZE, STANDARD_BUTTON_SIZE));
    }

    public static final Boolean clickedBox(Integer mouseX, Integer mouseY, Vector2Int buttonPos, Vector2Int buttonSize) {
        Integer buttonMinX = buttonPos.x();
        Integer buttonMaxX = buttonMinX + buttonSize.x();
        Integer buttonMinY = buttonPos.y();
        Integer buttonMaxY = buttonMinY + buttonSize.y();
        Boolean result = mouseX >= buttonMinX && mouseX <= buttonMaxX && mouseY >= buttonMinY && mouseY <= buttonMaxY;
        if (result.booleanValue()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
        return result;
    }

    public static void setAlpha(float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    public static String formatNumberAsString(Integer value, Integer minDigits, Boolean includePlus) {
        String numberString = value.toString();
        if (value < 0) {
            numberString = numberString.substring(1);
        }
        return (value < 0 ? "-" : (includePlus != false ? "+" : "")) + (String)(numberString.length() < minDigits ? "0".repeat(minDigits - numberString.length()) + numberString : numberString);
    }

    public static String truncateString(Font font, String source, Integer maxWidth) {
        if (source == null || font.m_92895_(source) <= maxWidth) {
            return source;
        }
        return font.m_92834_("..." + source, maxWidth.intValue()).substring(3) + "...";
    }

    public static List<String> wrapString(Font font, String source, Integer maxWidth, Integer maxLines) {
        if (source == null || font.m_92895_(source) <= maxWidth) {
            return List.of(source);
        }
        ArrayList<String> lines = new ArrayList<String>();
        String remaining = source;
        do {
            String part = font.m_92834_(remaining, maxWidth.intValue());
            remaining = source.substring(part.length());
            lines.add(part);
        } while (font.m_92895_(remaining) > maxWidth || lines.size() <= maxLines);
        lines.add(remaining);
        return lines;
    }

    public static void blitAbsolute(GuiGraphics graphics, ResourceLocation texture, int renderStartX, int renderStartY, float atlasStartX, float atlasStartY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        graphics.m_280163_(texture, renderStartX, renderStartY, atlasStartX, atlasStartY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    public static void drawStringAbsolute(GuiGraphics graphics, Font font, String string, Integer renderStartX, Integer renderStartY, Integer color) {
        graphics.m_280488_(font, string, renderStartX.intValue(), renderStartY.intValue(), color.intValue());
    }

    public static void pushLayer(GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
    }

    public static void rotateLayer(GuiGraphics graphics, Float degrees) {
        graphics.m_280168_().m_252781_(Axis.f_252393_.m_252977_(degrees.floatValue()));
    }

    public static void popLayer(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
    }
}

