/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.StandardFileFormat;
import io.github.tofodroid.com.sun.media.sound.SunFileReader;
import io.github.tofodroid.com.sun.media.sound.WaveFileFormat;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class WaveFileReader
extends SunFileReader {
    @Override
    StandardFileFormat getAudioFileFormatImpl(InputStream stream) throws UnsupportedAudioFileException, IOException {
        long totallength;
        int nread = 0;
        int length = 0;
        short wav_type = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dis = new DataInputStream(stream);
        int magic = dis.readInt();
        long fileLength = (long)this.rllong(dis) & 0xFFFFFFFFL;
        int waveMagic = dis.readInt();
        if (fileLength <= 0L) {
            fileLength = -1L;
            totallength = -1L;
        } else {
            totallength = fileLength + 8L;
        }
        if (magic != 1380533830 || waveMagic != 1463899717) {
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        try {
            while (true) {
                int fmt = dis.readInt();
                nread += 4;
                if (fmt != 1718449184) {
                    length = this.rllong(dis);
                    nread += 4;
                    if (length % 2 > 0) {
                        ++length;
                    }
                    nread += dis.skipBytes(length);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eof) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        length = this.rllong(dis);
        int endLength = (nread += 4) + length;
        wav_type = this.rlshort(dis);
        nread += 2;
        if (wav_type == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (wav_type == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (wav_type == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short channels = this.rlshort(dis);
        nread += 2;
        if (channels <= 0) {
            throw new UnsupportedAudioFileException("Invalid number of channels");
        }
        long sampleRate = this.rllong(dis);
        nread += 4;
        long avgBytesPerSec = this.rllong(dis);
        nread += 4;
        short blockAlign = this.rlshort(dis);
        nread += 2;
        short sampleSizeInBits = this.rlshort(dis);
        nread += 2;
        if (sampleSizeInBits <= 0) {
            throw new UnsupportedAudioFileException("Invalid bitsPerSample");
        }
        if (sampleSizeInBits == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (length % 2 != 0) {
            ++length;
        }
        if (endLength > nread) {
            nread += dis.skipBytes(endLength - nread);
        }
        nread = 0;
        try {
            while (true) {
                int datahdr = dis.readInt();
                nread += 4;
                if (datahdr != 1684108385) {
                    int thisLength = this.rllong(dis);
                    nread += 4;
                    if (thisLength % 2 > 0) {
                        ++thisLength;
                    }
                    nread += dis.skipBytes(thisLength);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eof) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        long dataLength = (long)this.rllong(dis) & 0xFFFFFFFFL;
        nread += 4;
        int frameSize = WaveFileReader.calculatePCMFrameSize(sampleSizeInBits, channels);
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, false);
        long frameLength = dataLength / (long)format.getFrameSize();
        return new WaveFileFormat(AudioFileFormat.Type.WAVE, totallength, format, frameLength);
    }
}

