/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.StandardFileFormat;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

abstract class SunFileReader
extends AudioFileReader {
    SunFileReader() {
    }

    @Override
    public final StandardFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        stream.mark(200);
        try {
            StandardFileFormat standardFileFormat = this.getAudioFileFormatImpl(stream);
            return standardFileFormat;
        }
        catch (EOFException ignored) {
            throw new UnsupportedAudioFileException();
        }
        finally {
            stream.reset();
        }
    }

    @Override
    public final AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        StandardFileFormat standardFileFormat;
        block8: {
            InputStream is = url.openStream();
            try {
                standardFileFormat = this.getAudioFileFormatImpl(new BufferedInputStream(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EOFException ignored) {
                    throw new UnsupportedAudioFileException();
                }
            }
            is.close();
        }
        return standardFileFormat;
    }

    @Override
    public final AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        StandardFileFormat standardFileFormat;
        FileInputStream is = new FileInputStream(file);
        try {
            standardFileFormat = this.getAudioFileFormatImpl(new BufferedInputStream(is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (EOFException ignored) {
                throw new UnsupportedAudioFileException();
            }
        }
        ((InputStream)is).close();
        return standardFileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        stream.mark(200);
        try {
            StandardFileFormat format = this.getAudioFileFormatImpl(stream);
            return new AudioInputStream(stream, format.getFormat(), format.getLongFrameLength());
        }
        catch (EOFException | UnsupportedAudioFileException ignored) {
            stream.reset();
            throw new UnsupportedAudioFileException();
        }
    }

    @Override
    public final AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = url.openStream();
        try {
            return this.getAudioInputStream(new BufferedInputStream(urlStream));
        }
        catch (Throwable e) {
            SunFileReader.closeSilently(urlStream);
            throw e;
        }
    }

    @Override
    public final AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(new BufferedInputStream(fileStream));
        }
        catch (Throwable e) {
            SunFileReader.closeSilently(fileStream);
            throw e;
        }
    }

    abstract StandardFileFormat getAudioFileFormatImpl(InputStream var1) throws UnsupportedAudioFileException, IOException;

    private static void closeSilently(InputStream is) {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final int rllong(DataInputStream dis) throws IOException {
        int i = 0;
        i = dis.readInt();
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    final int big2little(int i) {
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    final short rlshort(DataInputStream dis) throws IOException {
        short s = 0;
        s = dis.readShort();
        short high = (short)((s & 0xFF) << 8);
        short low = (short)((s & 0xFF00) >>> 8);
        s = (short)(high | low);
        return s;
    }

    final short big2littleShort(short i) {
        short high = (short)((i & 0xFF) << 8);
        short low = (short)((i & 0xFF00) >>> 8);
        i = (short)(high | low);
        return i;
    }

    static final int calculatePCMFrameSize(int sampleSizeInBits, int channels) {
        try {
            return Math.multiplyExact((sampleSizeInBits + 7) / 8, channels);
        }
        catch (ArithmeticException ignored) {
            return 0;
        }
    }
}

