/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;

public final class ModelByteBuffer {
    private ModelByteBuffer root = this;
    private File file;
    private long fileoffset;
    private byte[] buffer;
    private long offset;
    private final long len;

    private ModelByteBuffer(ModelByteBuffer parent, long beginIndex, long endIndex, boolean independent) {
        this.root = parent.root;
        this.offset = 0L;
        long parent_len = parent.len;
        if (beginIndex < 0L) {
            beginIndex = 0L;
        }
        if (beginIndex > parent_len) {
            beginIndex = parent_len;
        }
        if (endIndex < 0L) {
            endIndex = 0L;
        }
        if (endIndex > parent_len) {
            endIndex = parent_len;
        }
        if (beginIndex > endIndex) {
            beginIndex = endIndex;
        }
        this.offset = beginIndex;
        this.len = endIndex - beginIndex;
        if (independent) {
            this.buffer = this.root.buffer;
            if (this.root.file != null) {
                this.file = this.root.file;
                this.fileoffset = this.root.fileoffset + this.arrayOffset();
                this.offset = 0L;
            } else {
                this.offset = this.arrayOffset();
            }
            this.root = this;
        }
    }

    public ModelByteBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.offset = 0L;
        this.len = buffer.length;
    }

    public ModelByteBuffer(byte[] buffer, int offset, int len) {
        this.buffer = buffer;
        this.offset = offset;
        this.len = len;
    }

    public ModelByteBuffer(File file) {
        this.file = file;
        this.fileoffset = 0L;
        this.len = file.length();
    }

    public ModelByteBuffer(File file, long offset, long len) {
        this.file = file;
        this.fileoffset = offset;
        this.len = len;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.root.file != null && this.root.buffer == null) {
            try (InputStream is = this.getInputStream();){
                is.transferTo(out);
            }
        } else {
            out.write(this.array(), (int)this.arrayOffset(), (int)this.capacity());
        }
    }

    public InputStream getInputStream() {
        if (this.root.file != null && this.root.buffer == null) {
            try {
                return new RandomFileInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return new ByteArrayInputStream(this.array(), (int)this.arrayOffset(), (int)this.capacity());
    }

    public ModelByteBuffer subbuffer(long beginIndex) {
        return this.subbuffer(beginIndex, this.capacity());
    }

    public ModelByteBuffer subbuffer(long beginIndex, long endIndex) {
        return this.subbuffer(beginIndex, endIndex, false);
    }

    public ModelByteBuffer subbuffer(long beginIndex, long endIndex, boolean independent) {
        return new ModelByteBuffer(this, beginIndex, endIndex, independent);
    }

    public byte[] array() {
        return this.root.buffer;
    }

    public long arrayOffset() {
        if (this.root != this) {
            return this.root.arrayOffset() + this.offset;
        }
        return this.offset;
    }

    public long capacity() {
        return this.len;
    }

    public ModelByteBuffer getRoot() {
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public long getFilePointer() {
        return this.fileoffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAll(Collection<ModelByteBuffer> col) throws IOException {
        File selfile = null;
        try (RandomAccessFile raf = null;){
            for (ModelByteBuffer mbuff : col) {
                mbuff = mbuff.root;
                if (mbuff.file == null || mbuff.buffer != null) continue;
                if (selfile == null || !selfile.equals(mbuff.file)) {
                    if (raf != null) {
                        raf.close();
                        raf = null;
                    }
                    selfile = mbuff.file;
                    raf = new RandomAccessFile(mbuff.file, "r");
                }
                raf.seek(mbuff.fileoffset);
                byte[] buffer = new byte[(int)mbuff.capacity()];
                int read = 0;
                int avail = buffer.length;
                while (read != avail) {
                    if (avail - read > 65536) {
                        raf.readFully(buffer, read, 65536);
                        read += 65536;
                        continue;
                    }
                    raf.readFully(buffer, read, avail - read);
                    read = avail;
                }
                mbuff.buffer = buffer;
                mbuff.offset = 0L;
            }
        }
    }

    public void load() throws IOException {
        if (this.root != this) {
            this.root.load();
            return;
        }
        if (this.buffer != null) {
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("No file associated with this ByteBuffer!");
        }
        try (InputStream is = this.getInputStream();
             DataInputStream dis = new DataInputStream(is);){
            this.buffer = new byte[(int)this.capacity()];
            this.offset = 0L;
            dis.readFully(this.buffer);
        }
    }

    public void unload() {
        if (this.root != this) {
            this.root.unload();
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("No file associated with this ByteBuffer!");
        }
        this.root.buffer = null;
    }

    private class RandomFileInputStream
    extends InputStream {
        private final RandomAccessFile raf;
        private long left;
        private long mark = 0L;
        private long markleft = 0L;

        RandomFileInputStream() throws IOException {
            this.raf = new RandomAccessFile(ModelByteBuffer.this.root.file, "r");
            this.raf.seek(ModelByteBuffer.this.root.fileoffset + ModelByteBuffer.this.arrayOffset());
            this.left = ModelByteBuffer.this.capacity();
        }

        @Override
        public int available() throws IOException {
            if (this.left > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)this.left;
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.mark = this.raf.getFilePointer();
                this.markleft = this.left;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.raf.seek(this.mark);
            this.left = this.markleft;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n < 0L) {
                return 0L;
            }
            if (n > this.left) {
                n = this.left;
            }
            long p = this.raf.getFilePointer();
            this.raf.seek(p + n);
            this.left -= n;
            return n;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if ((long)len > this.left) {
                len = (int)this.left;
            }
            if (this.left == 0L) {
                return -1;
            }
            if ((len = this.raf.read(b, off, len)) == -1) {
                return -1;
            }
            this.left -= (long)len;
            return len;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int len = b.length;
            if ((long)len > this.left) {
                len = (int)this.left;
            }
            if (this.left == 0L) {
                return -1;
            }
            if ((len = this.raf.read(b, 0, len)) == -1) {
                return -1;
            }
            this.left -= (long)len;
            return len;
        }

        @Override
        public int read() throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int b = this.raf.read();
            if (b == -1) {
                return -1;
            }
            --this.left;
            return b;
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }
}

