/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.SimpleSoundbank;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;

public final class JARSoundbankReader
extends SoundbankReader {
    private static boolean isZIP(URL url) {
        boolean ok = false;
        try (InputStream stream = url.openStream();){
            byte[] buff = new byte[4];
            boolean bl = ok = stream.read(buff) == 4;
            if (ok) {
                ok = buff[0] == 80 && buff[1] == 75 && buff[2] == 3 && buff[3] == 4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ok;
    }

    @Override
    public Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        if (!JARSoundbankReader.isZIP(url)) {
            return null;
        }
        ArrayList<Soundbank> soundbanks = new ArrayList<Soundbank>();
        URLClassLoader ucl = URLClassLoader.newInstance(new URL[]{url});
        InputStream stream = ucl.getResourceAsStream("META-INF/services/javax.sound.midi.Soundbank");
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            BufferedReader r = new BufferedReader(new InputStreamReader(stream));
            String line = r.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    try {
                        Class<?> c = Class.forName(line.trim(), false, ucl);
                        if (Soundbank.class.isAssignableFrom(c)) {
                            Object o = c.newInstance();
                            soundbanks.add((Soundbank)o);
                        }
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                line = r.readLine();
            }
        }
        if (soundbanks.size() == 0) {
            return null;
        }
        if (soundbanks.size() == 1) {
            return (Soundbank)soundbanks.get(0);
        }
        SimpleSoundbank sbk = new SimpleSoundbank();
        for (Soundbank soundbank : soundbanks) {
            sbk.addAllInstruments(soundbank);
        }
        return sbk;
    }

    @Override
    public Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        Objects.requireNonNull(stream);
        return null;
    }

    @Override
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        return this.getSoundbank(file.toURI().toURL());
    }
}

