/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.DirectAudioDevice;
import io.github.tofodroid.com.sun.media.sound.Platform;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public final class DirectAudioDeviceProvider
extends MixerProvider {
    private static DirectAudioDeviceInfo[] infos;
    private static DirectAudioDevice[] devices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectAudioDeviceProvider() {
        Class<DirectAudioDeviceProvider> clazz = DirectAudioDeviceProvider.class;
        synchronized (DirectAudioDeviceProvider.class) {
            if (Platform.isDirectAudioEnabled()) {
                DirectAudioDeviceProvider.init();
            } else {
                infos = new DirectAudioDeviceInfo[0];
                devices = new DirectAudioDevice[0];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void init() {
        int numDevices = DirectAudioDeviceProvider.nGetNumDevices();
        if (infos == null || infos.length != numDevices) {
            infos = new DirectAudioDeviceInfo[numDevices];
            devices = new DirectAudioDevice[numDevices];
            for (int i = 0; i < infos.length; ++i) {
                DirectAudioDeviceProvider.infos[i] = DirectAudioDeviceProvider.nNewDirectAudioDeviceInfo(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        Class<DirectAudioDeviceProvider> clazz = DirectAudioDeviceProvider.class;
        synchronized (DirectAudioDeviceProvider.class) {
            Mixer.Info[] localArray = new Mixer.Info[infos.length];
            System.arraycopy(infos, 0, localArray, 0, infos.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info) {
        Class<DirectAudioDeviceProvider> clazz = DirectAudioDeviceProvider.class;
        synchronized (DirectAudioDeviceProvider.class) {
            int i;
            if (info == null) {
                for (i = 0; i < infos.length; ++i) {
                    Mixer mixer = DirectAudioDeviceProvider.getDevice(infos[i]);
                    if (mixer.getSourceLineInfo().length <= 0) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return mixer;
                }
            }
            for (i = 0; i < infos.length; ++i) {
                if (!infos[i].equals(info)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return DirectAudioDeviceProvider.getDevice(infos[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new IllegalArgumentException(String.format("Mixer %s not supported by this provider", info));
        }
    }

    private static Mixer getDevice(DirectAudioDeviceInfo info) {
        int index = info.getIndex();
        if (devices[index] == null) {
            DirectAudioDeviceProvider.devices[index] = new DirectAudioDevice(info);
        }
        return devices[index];
    }

    private static native int nGetNumDevices();

    private static native DirectAudioDeviceInfo nNewDirectAudioDeviceInfo(int var0);

    static {
        Platform.initialize();
    }

    static final class DirectAudioDeviceInfo
    extends Mixer.Info {
        private final int index;
        private final int maxSimulLines;
        private final int deviceID;

        private DirectAudioDeviceInfo(int index, int deviceID, int maxSimulLines, String name, String vendor, String description, String version) {
            super(name, vendor, "Direct Audio Device: " + description, version);
            this.index = index;
            this.maxSimulLines = maxSimulLines;
            this.deviceID = deviceID;
        }

        int getIndex() {
            return this.index;
        }

        int getMaxSimulLines() {
            return this.maxSimulLines;
        }

        int getDeviceID() {
            return this.deviceID;
        }
    }
}

