/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import javax.sound.sampled.AudioFormat;

public abstract class AudioFloatConverter {
    private AudioFormat format;

    public static AudioFloatConverter getConverter(AudioFormat format) {
        AudioFloatConverter conv = null;
        if (format.getFrameSize() == 0) {
            return null;
        }
        if (format.getFrameSize() != (format.getSampleSizeInBits() + 7) / 8 * format.getChannels()) {
            return null;
        }
        if (format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (format.isBigEndian()) {
                if (format.getSampleSizeInBits() <= 8) {
                    conv = new AudioFloatConversion8S();
                } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                    conv = new AudioFloatConversion16SB();
                } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                    conv = new AudioFloatConversion24SB();
                } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                    conv = new AudioFloatConversion32SB();
                } else if (format.getSampleSizeInBits() > 32) {
                    conv = new AudioFloatConversion32xSB((format.getSampleSizeInBits() + 7) / 8 - 4);
                }
            } else if (format.getSampleSizeInBits() <= 8) {
                conv = new AudioFloatConversion8S();
            } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                conv = new AudioFloatConversion16SL();
            } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                conv = new AudioFloatConversion24SL();
            } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                conv = new AudioFloatConversion32SL();
            } else if (format.getSampleSizeInBits() > 32) {
                conv = new AudioFloatConversion32xSL((format.getSampleSizeInBits() + 7) / 8 - 4);
            }
        } else if (format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            if (format.isBigEndian()) {
                if (format.getSampleSizeInBits() <= 8) {
                    conv = new AudioFloatConversion8U();
                } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                    conv = new AudioFloatConversion16UB();
                } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                    conv = new AudioFloatConversion24UB();
                } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                    conv = new AudioFloatConversion32UB();
                } else if (format.getSampleSizeInBits() > 32) {
                    conv = new AudioFloatConversion32xUB((format.getSampleSizeInBits() + 7) / 8 - 4);
                }
            } else if (format.getSampleSizeInBits() <= 8) {
                conv = new AudioFloatConversion8U();
            } else if (format.getSampleSizeInBits() > 8 && format.getSampleSizeInBits() <= 16) {
                conv = new AudioFloatConversion16UL();
            } else if (format.getSampleSizeInBits() > 16 && format.getSampleSizeInBits() <= 24) {
                conv = new AudioFloatConversion24UL();
            } else if (format.getSampleSizeInBits() > 24 && format.getSampleSizeInBits() <= 32) {
                conv = new AudioFloatConversion32UL();
            } else if (format.getSampleSizeInBits() > 32) {
                conv = new AudioFloatConversion32xUL((format.getSampleSizeInBits() + 7) / 8 - 4);
            }
        } else if (format.getEncoding().equals(AudioFormat.Encoding.PCM_FLOAT)) {
            if (format.getSampleSizeInBits() == 32) {
                conv = format.isBigEndian() ? new AudioFloatConversion32B() : new AudioFloatConversion32L();
            } else if (format.getSampleSizeInBits() == 64) {
                conv = format.isBigEndian() ? new AudioFloatConversion64B() : new AudioFloatConversion64L();
            }
        }
        if ((format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) && format.getSampleSizeInBits() % 8 != 0) {
            conv = new AudioFloatLSBFilter(conv, format);
        }
        if (conv != null) {
            conv.format = format;
        }
        return conv;
    }

    public final AudioFormat getFormat() {
        return this.format;
    }

    public abstract float[] toFloatArray(byte[] var1, int var2, float[] var3, int var4, int var5);

    public final float[] toFloatArray(byte[] in_buff, float[] out_buff, int out_offset, int out_len) {
        return this.toFloatArray(in_buff, 0, out_buff, out_offset, out_len);
    }

    public final float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_len) {
        return this.toFloatArray(in_buff, in_offset, out_buff, 0, out_len);
    }

    public final float[] toFloatArray(byte[] in_buff, float[] out_buff, int out_len) {
        return this.toFloatArray(in_buff, 0, out_buff, 0, out_len);
    }

    public final float[] toFloatArray(byte[] in_buff, float[] out_buff) {
        return this.toFloatArray(in_buff, 0, out_buff, 0, out_buff.length);
    }

    public abstract byte[] toByteArray(float[] var1, int var2, int var3, byte[] var4, int var5);

    public final byte[] toByteArray(float[] in_buff, int in_len, byte[] out_buff, int out_offset) {
        return this.toByteArray(in_buff, 0, in_len, out_buff, out_offset);
    }

    public final byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff) {
        return this.toByteArray(in_buff, in_offset, in_len, out_buff, 0);
    }

    public final byte[] toByteArray(float[] in_buff, int in_len, byte[] out_buff) {
        return this.toByteArray(in_buff, 0, in_len, out_buff, 0);
    }

    public final byte[] toByteArray(float[] in_buff, byte[] out_buff) {
        return this.toByteArray(in_buff, 0, in_buff.length, out_buff, 0);
    }

    private static class AudioFloatConversion8S
    extends AudioFloatConverter {
        private AudioFloatConversion8S() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                byte x = in_buff[ix++];
                out_buff[ox++] = x > 0 ? (float)x / 127.0f : (float)x / 128.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float x = in_buff[ix++];
                out_buff[ox++] = (byte)(x > 0.0f ? x * 127.0f : x * 128.0f);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16SB
    extends AudioFloatConverter {
        private AudioFloatConversion16SB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                short x = (short)(in_buff[ix++] << 8 | in_buff[ix++] & 0xFF);
                out_buff[ox++] = x > 0 ? (float)x / 32767.0f : (float)x / 32768.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                short x = (short)((f = in_buff[ix++]) > 0.0f ? f * 32767.0f : f * 32768.0f);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24SB
    extends AudioFloatConverter {
        private AudioFloatConversion24SB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x;
                if ((x = (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF) > 0x7FFFFF) {
                    x -= 0x1000000;
                }
                out_buff[ox++] = x > 0 ? (float)x / 8388607.0f : (float)x / 8388608.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                int x;
                if ((x = (int)((f = in_buff[ix++]) > 0.0f ? f * 8388607.0f : f * 8388608.0f)) < 0) {
                    x += 0x1000000;
                }
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32SB
    extends AudioFloatConverter {
        private AudioFloatConversion32SB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 24 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (float)x * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                out_buff[ox++] = (byte)(x >>> 24);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32xSB
    extends AudioFloatConverter {
        private final int xbytes;

        AudioFloatConversion32xSB(int xbytes) {
            this.xbytes = xbytes;
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 24 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                ix += this.xbytes;
                out_buff[ox++] = (float)x * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                out_buff[ox++] = (byte)(x >>> 24);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
                for (int j = 0; j < this.xbytes; ++j) {
                    out_buff[ox++] = 0;
                }
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16SL
    extends AudioFloatConverter {
        private AudioFloatConversion16SL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int len = out_offset + out_len;
            for (int ox = out_offset; ox < len; ++ox) {
                short x;
                out_buff[ox] = (x = (short)(in_buff[ix++] & 0xFF | in_buff[ix++] << 8)) > 0 ? (float)x / 32767.0f : (float)x / 32768.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ox = out_offset;
            int len = in_offset + in_len;
            for (int ix = in_offset; ix < len; ++ix) {
                float f = in_buff[ix];
                short x = (short)(f > 0.0f ? f * 32767.0f : f * 32768.0f);
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24SL
    extends AudioFloatConverter {
        private AudioFloatConversion24SL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x;
                if ((x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16) > 0x7FFFFF) {
                    x -= 0x1000000;
                }
                out_buff[ox++] = x > 0 ? (float)x / 8388607.0f : (float)x / 8388608.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                int x;
                if ((x = (int)((f = in_buff[ix++]) > 0.0f ? f * 8388607.0f : f * 8388608.0f)) < 0) {
                    x += 0x1000000;
                }
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32SL
    extends AudioFloatConverter {
        private AudioFloatConversion32SL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 24;
                out_buff[ox++] = (float)x * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 24);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32xSL
    extends AudioFloatConverter {
        private final int xbytes;

        AudioFloatConversion32xSL(int xbytes) {
            this.xbytes = xbytes;
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                ix += this.xbytes;
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 24;
                out_buff[ox++] = (float)x * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                for (int j = 0; j < this.xbytes; ++j) {
                    out_buff[ox++] = 0;
                }
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 24);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion8U
    extends AudioFloatConverter {
        private AudioFloatConversion8U() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                byte x = (byte)(in_buff[ix++] - 128);
                out_buff[ox++] = x > 0 ? (float)x / 127.0f : (float)x / 128.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float x = in_buff[ix++];
                out_buff[ox++] = (byte)(128.0f + (x > 0.0f ? x * 127.0f : x * 128.0f));
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16UB
    extends AudioFloatConverter {
        private AudioFloatConversion16UB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (x -= 32768) > 0 ? (float)x / 32767.0f : (float)x / 32768.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                int x = 32768 + (int)((f = in_buff[ix++]) > 0.0f ? f * 32767.0f : f * 32768.0f);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24UB
    extends AudioFloatConverter {
        private AudioFloatConversion24UB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (x -= 0x800000) > 0 ? (float)x / 8388607.0f : (float)x / 8388608.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                int x = (int)((f = in_buff[ix++]) > 0.0f ? f * 8388607.0f : f * 8388608.0f);
                out_buff[ox++] = (byte)((x += 0x800000) >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32UB
    extends AudioFloatConverter {
        private AudioFloatConversion32UB() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 24 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                out_buff[ox++] = (float)(x -= Integer.MIN_VALUE) * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                out_buff[ox++] = (byte)((x -= Integer.MIN_VALUE) >>> 24);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32xUB
    extends AudioFloatConverter {
        private final int xbytes;

        AudioFloatConversion32xUB(int xbytes) {
            this.xbytes = xbytes;
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = (in_buff[ix++] & 0xFF) << 24 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 8 | in_buff[ix++] & 0xFF;
                ix += this.xbytes;
                out_buff[ox++] = (float)(x -= Integer.MIN_VALUE) * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                out_buff[ox++] = (byte)((x -= Integer.MIN_VALUE) >>> 24);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)x;
                for (int j = 0; j < this.xbytes; ++j) {
                    out_buff[ox++] = 0;
                }
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion16UL
    extends AudioFloatConverter {
        private AudioFloatConversion16UL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8;
                out_buff[ox++] = (x -= 32768) > 0 ? (float)x / 32767.0f : (float)x / 32768.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                int x = 32768 + (int)((f = in_buff[ix++]) > 0.0f ? f * 32767.0f : f * 32768.0f);
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion24UL
    extends AudioFloatConverter {
        private AudioFloatConversion24UL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16;
                out_buff[ox++] = (x -= 0x800000) > 0 ? (float)x / 8388607.0f : (float)x / 8388608.0f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                float f;
                int x = (int)((f = in_buff[ix++]) > 0.0f ? f * 8388607.0f : f * 8388608.0f);
                out_buff[ox++] = (byte)(x += 0x800000);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32UL
    extends AudioFloatConverter {
        private AudioFloatConversion32UL() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 24;
                out_buff[ox++] = (float)(x -= Integer.MIN_VALUE) * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                out_buff[ox++] = (byte)(x -= Integer.MIN_VALUE);
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 24);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32xUL
    extends AudioFloatConverter {
        private final int xbytes;

        AudioFloatConversion32xUL(int xbytes) {
            this.xbytes = xbytes;
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < out_len; ++i) {
                ix += this.xbytes;
                int x = in_buff[ix++] & 0xFF | (in_buff[ix++] & 0xFF) << 8 | (in_buff[ix++] & 0xFF) << 16 | (in_buff[ix++] & 0xFF) << 24;
                out_buff[ox++] = (float)(x -= Integer.MIN_VALUE) * 4.656613E-10f;
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int ix = in_offset;
            int ox = out_offset;
            for (int i = 0; i < in_len; ++i) {
                int x = (int)(in_buff[ix++] * 2.1474836E9f);
                x -= Integer.MIN_VALUE;
                for (int j = 0; j < this.xbytes; ++j) {
                    out_buff[ox++] = 0;
                }
                out_buff[ox++] = (byte)x;
                out_buff[ox++] = (byte)(x >>> 8);
                out_buff[ox++] = (byte)(x >>> 16);
                out_buff[ox++] = (byte)(x >>> 24);
            }
            return out_buff;
        }
    }

    private static class AudioFloatConversion32B
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        FloatBuffer floatbuffer = null;

        private AudioFloatConversion32B() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int in_len = out_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < in_len) {
                this.bytebuffer = ByteBuffer.allocate(in_len).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(in_buff, in_offset, in_len);
            this.floatbuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int out_len = in_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < out_len) {
                this.bytebuffer = ByteBuffer.allocate(out_len).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            this.floatbuffer.put(in_buff, in_offset, in_len);
            this.bytebuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }
    }

    private static class AudioFloatConversion32L
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        FloatBuffer floatbuffer = null;

        private AudioFloatConversion32L() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int in_len = out_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < in_len) {
                this.bytebuffer = ByteBuffer.allocate(in_len).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(in_buff, in_offset, in_len);
            this.floatbuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int out_len = in_len * 4;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < out_len) {
                this.bytebuffer = ByteBuffer.allocate(out_len).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asFloatBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            this.floatbuffer.put(in_buff, in_offset, in_len);
            this.bytebuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }
    }

    private static class AudioFloatConversion64B
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        DoubleBuffer floatbuffer = null;
        double[] double_buff = null;

        private AudioFloatConversion64B() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int in_len = out_len * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < in_len) {
                this.bytebuffer = ByteBuffer.allocate(in_len).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(in_buff, in_offset, in_len);
            if (this.double_buff == null || this.double_buff.length < out_len + out_offset) {
                this.double_buff = new double[out_len + out_offset];
            }
            this.floatbuffer.get(this.double_buff, out_offset, out_len);
            int out_offset_end = out_offset + out_len;
            for (int i = out_offset; i < out_offset_end; ++i) {
                out_buff[i] = (float)this.double_buff[i];
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int out_len = in_len * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < out_len) {
                this.bytebuffer = ByteBuffer.allocate(out_len).order(ByteOrder.BIG_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            if (this.double_buff == null || this.double_buff.length < in_offset + in_len) {
                this.double_buff = new double[in_offset + in_len];
            }
            int in_offset_end = in_offset + in_len;
            for (int i = in_offset; i < in_offset_end; ++i) {
                this.double_buff[i] = in_buff[i];
            }
            this.floatbuffer.put(this.double_buff, in_offset, in_len);
            this.bytebuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }
    }

    private static class AudioFloatConversion64L
    extends AudioFloatConverter {
        ByteBuffer bytebuffer = null;
        DoubleBuffer floatbuffer = null;
        double[] double_buff = null;

        private AudioFloatConversion64L() {
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            int in_len = out_len * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < in_len) {
                this.bytebuffer = ByteBuffer.allocate(in_len).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.bytebuffer.position(0);
            this.floatbuffer.position(0);
            this.bytebuffer.put(in_buff, in_offset, in_len);
            if (this.double_buff == null || this.double_buff.length < out_len + out_offset) {
                this.double_buff = new double[out_len + out_offset];
            }
            this.floatbuffer.get(this.double_buff, out_offset, out_len);
            int out_offset_end = out_offset + out_len;
            for (int i = out_offset; i < out_offset_end; ++i) {
                out_buff[i] = (float)this.double_buff[i];
            }
            return out_buff;
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            int out_len = in_len * 8;
            if (this.bytebuffer == null || this.bytebuffer.capacity() < out_len) {
                this.bytebuffer = ByteBuffer.allocate(out_len).order(ByteOrder.LITTLE_ENDIAN);
                this.floatbuffer = this.bytebuffer.asDoubleBuffer();
            }
            this.floatbuffer.position(0);
            this.bytebuffer.position(0);
            if (this.double_buff == null || this.double_buff.length < in_offset + in_len) {
                this.double_buff = new double[in_offset + in_len];
            }
            int in_offset_end = in_offset + in_len;
            for (int i = in_offset; i < in_offset_end; ++i) {
                this.double_buff[i] = in_buff[i];
            }
            this.floatbuffer.put(this.double_buff, in_offset, in_len);
            this.bytebuffer.get(out_buff, out_offset, out_len);
            return out_buff;
        }
    }

    private static class AudioFloatLSBFilter
    extends AudioFloatConverter {
        private final AudioFloatConverter converter;
        private final int offset;
        private final int stepsize;
        private final byte mask;
        private byte[] mask_buffer;

        AudioFloatLSBFilter(AudioFloatConverter converter, AudioFormat format) {
            int bits = format.getSampleSizeInBits();
            boolean bigEndian = format.isBigEndian();
            this.converter = converter;
            this.stepsize = (bits + 7) / 8;
            this.offset = bigEndian ? this.stepsize - 1 : 0;
            int lsb_bits = bits % 8;
            this.mask = lsb_bits == 0 ? (byte)0 : (lsb_bits == 1 ? (byte)-128 : (lsb_bits == 2 ? (byte)-64 : (lsb_bits == 3 ? (byte)-32 : (lsb_bits == 4 ? (byte)-16 : (lsb_bits == 5 ? (byte)-8 : (lsb_bits == 6 ? (byte)-4 : (lsb_bits == 7 ? (byte)-2 : (byte)-1)))))));
        }

        @Override
        public byte[] toByteArray(float[] in_buff, int in_offset, int in_len, byte[] out_buff, int out_offset) {
            byte[] ret = this.converter.toByteArray(in_buff, in_offset, in_len, out_buff, out_offset);
            int out_offset_end = in_len * this.stepsize;
            for (int i = out_offset + this.offset; i < out_offset_end; i += this.stepsize) {
                out_buff[i] = (byte)(out_buff[i] & this.mask);
            }
            return ret;
        }

        @Override
        public float[] toFloatArray(byte[] in_buff, int in_offset, float[] out_buff, int out_offset, int out_len) {
            if (this.mask_buffer == null || this.mask_buffer.length < in_buff.length) {
                this.mask_buffer = new byte[in_buff.length];
            }
            System.arraycopy(in_buff, 0, this.mask_buffer, 0, in_buff.length);
            int in_offset_end = out_len * this.stepsize;
            for (int i = in_offset + this.offset; i < in_offset_end; i += this.stepsize) {
                this.mask_buffer[i] = (byte)(this.mask_buffer[i] & this.mask);
            }
            float[] ret = this.converter.toFloatArray(this.mask_buffer, in_offset, out_buff, out_offset, out_len);
            return ret;
        }
    }
}

