/*
 * Decompiled with CFR 0.152.
 */
package io.github.tofodroid.com.sun.media.sound;

import io.github.tofodroid.com.sun.media.sound.AuFileFormat;
import io.github.tofodroid.com.sun.media.sound.StandardFileFormat;
import io.github.tofodroid.com.sun.media.sound.SunFileReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class AuFileReader
extends SunFileReader {
    @Override
    StandardFileFormat getAudioFileFormatImpl(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding;
        DataInputStream dis = new DataInputStream(stream);
        int magic = dis.readInt();
        if (magic != 779316836) {
            throw new UnsupportedAudioFileException("not an AU file");
        }
        int headerSize = dis.readInt();
        if (headerSize < 24) {
            throw new UnsupportedAudioFileException("Invalid header size");
        }
        long dataSize = (long)dis.readInt() & 0xFFFFFFFFL;
        int auType = dis.readInt();
        int sampleRate = dis.readInt();
        if (sampleRate <= 0) {
            throw new UnsupportedAudioFileException("Invalid sample rate");
        }
        int channels = dis.readInt();
        if (channels <= 0) {
            throw new UnsupportedAudioFileException("Invalid number of channels");
        }
        int sampleSizeInBits = switch (auType) {
            case 1 -> {
                encoding = AudioFormat.Encoding.ULAW;
                yield 8;
            }
            case 27 -> {
                encoding = AudioFormat.Encoding.ALAW;
                yield 8;
            }
            case 2 -> {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                yield 8;
            }
            case 3 -> {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                yield 16;
            }
            case 4 -> {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                yield 24;
            }
            case 5 -> {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                yield 32;
            }
            case 6 -> {
                encoding = AudioFormat.Encoding.PCM_FLOAT;
                yield 32;
            }
            case 7 -> {
                encoding = AudioFormat.Encoding.PCM_FLOAT;
                yield 64;
            }
            default -> throw new UnsupportedAudioFileException("not a valid AU file");
        };
        dis.skipBytes(headerSize - 24);
        int frameSize = AuFileReader.calculatePCMFrameSize(sampleSizeInBits, channels);
        if (frameSize <= 0) {
            throw new UnsupportedAudioFileException("Invalid frame size");
        }
        long frameLength = -1L;
        long byteLength = -1L;
        if (dataSize != 0xFFFFFFFFL) {
            frameLength = dataSize / (long)frameSize;
            byteLength = dataSize + (long)headerSize;
        }
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, true);
        return new AuFileFormat(AudioFileFormat.Type.AU, byteLength, format, frameLength);
    }
}

