/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.NBTUtils;
import vazkii.akashictome.network.MessageMorphTome;
import vazkii.akashictome.network.NetworkHandler;

public class TomeScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("akashictome:textures/models/book.png");
    private final BookModel BOOK_MODEL;
    final ItemStack tome;
    String definedMod;

    public TomeScreen(ItemStack tome) {
        super((Component)Component.m_237119_());
        this.tome = tome;
        this.BOOK_MODEL = new BookModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171271_));
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (p_mouseClicked_5_ == 0 && this.definedMod != null) {
            NetworkHandler.sendToServer(new MessageMorphTome(this.definedMod));
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = pGuiGraphics.m_280168_();
        this.definedMod = null;
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.tome.m_41782_()) {
            CompoundTag data = this.tome.m_41783_().m_128469_("akashictome:data");
            ArrayList keys = Lists.newArrayList((Iterable)data.m_128431_());
            Collections.sort(keys);
            for (String s : keys) {
                CompoundTag cmp = data.m_128469_(s);
                if (cmp == null) continue;
                ItemStack modStack = ItemStack.m_41712_((CompoundTag)cmp);
                stacks.add(modStack);
            }
        }
        Window window = this.f_96541_.m_91268_();
        int centerX = window.m_85445_() / 2;
        int centerY = window.m_85446_() / 2;
        int amountPerRow = 6;
        int rows = stacks.size() / amountPerRow + 1;
        int iconSize = 20;
        int startX = centerX - amountPerRow * iconSize / 2;
        int startY = centerY - rows * iconSize + 45;
        int padding = 4;
        int extra = 2;
        int endX = startX + iconSize * amountPerRow;
        int endY = startY + iconSize * rows;
        pGuiGraphics.m_280509_(startX - padding, startY - padding, endX + padding, endY + padding, 0x22000000);
        pGuiGraphics.m_280509_(startX - padding - extra, startY - padding - extra, endX + padding + extra, endY + padding + extra, 0x22000000);
        ItemStack tooltipStack = ItemStack.f_41583_;
        if (!stacks.isEmpty()) {
            for (int i = 0; i < stacks.size(); ++i) {
                int x = startX + i % amountPerRow * iconSize;
                int y = startY + i / amountPerRow * iconSize;
                ItemStack stack = (ItemStack)stacks.get(i);
                if (mouseX > x && mouseY > y && mouseX <= x + 16 && mouseY <= y + 16) {
                    tooltipStack = stack;
                    y -= 2;
                }
                pGuiGraphics.m_280480_(stack, x, y);
            }
        }
        if (!tooltipStack.m_41619_()) {
            CompoundTag name = NBTUtils.getCompound(tooltipStack, "akashictome:displayName", false);
            String tempDefinedMod = MorphingHandler.getModFromStack(tooltipStack);
            String mod = ChatFormatting.GRAY + MorphingHandler.getModNameForId(tempDefinedMod);
            tempDefinedMod = NBTUtils.getString(tooltipStack, "akashictome:definedMod", tempDefinedMod);
            MutableComponent comp = Component.Serializer.m_130701_((String)name.m_128461_("text"));
            if (comp == null) {
                comp = tooltipStack.m_41786_();
            }
            List<Component> tooltipList = Arrays.asList(comp, Component.m_237113_((String)mod));
            pGuiGraphics.m_280666_(this.f_96547_, tooltipList, mouseX, mouseY);
            this.definedMod = tempDefinedMod;
        }
        if (!((Boolean)ConfigHandler.hideBookRender.get()).booleanValue()) {
            float f = 1.0f;
            float f1 = 0.0f;
            Lighting.m_166384_();
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(startX + endX) / 2.0, (double)(startY - 45), 100.0);
            float f2 = 100.0f;
            matrixStack.m_85841_(-f2, f2, f2);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            matrixStack.m_252880_((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, (1.0f - f) * 0.25f);
            float f3 = -(1.0f - f) * 90.0f - 91.0f;
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(f3));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            float f4 = Mth.m_14036_((float)(Mth.m_14187_((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
            float f5 = Mth.m_14036_((float)(Mth.m_14187_((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
            this.BOOK_MODEL.m_102292_(0.0f, f4, f5, f);
            VertexConsumer vertexconsumer = pGuiGraphics.m_280091_().m_6299_(this.BOOK_MODEL.m_103119_(BOOK_TEXTURE));
            this.BOOK_MODEL.m_7695_(matrixStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.m_280262_();
            matrixStack.m_85849_();
            Lighting.m_84931_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

