/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.ScaleUtils;

public class ScalePacket {
    public final int entityId;
    public final Collection<ScaleData> scales = new ArrayList<ScaleData>();
    public final Map<ResourceLocation, CompoundTag> syncedScales = new HashMap<ResourceLocation, CompoundTag>();

    public ScalePacket(Entity entity, Collection<ScaleData> scales) {
        this.entityId = entity.m_19879_();
        this.scales.addAll(scales);
        for (ScaleData s : scales) {
            ResourceLocation typeId = ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, s.getScaleType());
            this.syncedScales.put(typeId, s.writeNbt(new CompoundTag()));
        }
    }

    public ScalePacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        for (int i = buf.readInt(); i > 0; --i) {
            ResourceLocation typeId = buf.m_130281_();
            CompoundTag scaleData = ScaleUtils.buildScaleNbtFromPacketByteBuf(buf);
            this.syncedScales.put(typeId, scaleData);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.writeInt(this.scales.size());
        for (ScaleData s : this.scales) {
            buf.m_130085_(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, s.getScaleType()));
            s.toPacket(buf);
        }
    }
}

