/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.util.tri;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.mr_toad.lib.mtjava.annotations.TypesAreNonnullByDefault;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import net.minecraft.FieldsAreNonnullByDefault;

@FieldsAreNonnullByDefault
@TypesAreNonnullByDefault
public class Triplet<F, S, T> {
    public final F first;
    public final S second;
    public final T third;

    protected Triplet(F first, S second, T third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <F, S, T> Triplet<F, S, T> of(F first, S second, T third) {
        return new Triplet<F, S, T>(first, second, third);
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public T getThird() {
        return this.third;
    }

    public Triplet<S, F, T> swapFS() {
        return Triplet.of(this.getSecond(), this.getFirst(), this.getThird());
    }

    public Triplet<T, S, F> swapFT() {
        return Triplet.of(this.getThird(), this.getSecond(), this.getFirst());
    }

    public Triplet<F, T, S> swapST() {
        return Triplet.of(this.getFirst(), this.getThird(), this.getSecond());
    }

    public <F2> Triplet<F2, S, T> mapFirst(Function<? super F, ? extends F2> function) {
        return Triplet.of(function.apply(this.getFirst()), this.getSecond(), this.getThird());
    }

    public <S2> Triplet<F, S2, T> mapSecond(Function<? super S, ? extends S2> function) {
        return Triplet.of(this.getFirst(), function.apply(this.getSecond()), this.getThird());
    }

    public <T2> Triplet<F, S, T2> mapThird(Function<? super T, ? extends T2> function) {
        return Triplet.of(this.getFirst(), this.getSecond(), function.apply(this.getThird()));
    }

    @Beta
    public static <F, S, T> Collector<Triplet<F, S, T>, ?, Table<F, S, T>> toTable() {
        return Tables.toTable(Triplet::getFirst, Triplet::getSecond, Triplet::getThird, HashBasedTable::create);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("First", this.getFirst()).add("Second", this.getSecond()).add("Third", this.getThird()).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Triplet)) {
            return false;
        }
        Triplet other = (Triplet)obj;
        return Objects.equals(this.getFirst(), other.getFirst()) && Objects.equals(this.getSecond(), other.getSecond()) && Objects.equals(this.getThird(), other.getThird());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getFirst(), this.getSecond(), this.getThird()});
    }
}

