/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.mtjava.strings;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.mr_toad.lib.mtjava.chars.OptionalChar;
import com.mr_toad.lib.mtjava.strings.func.String2CharFunction;
import com.mr_toad.lib.mtjava.strings.func.String2StringFunction;
import com.mr_toad.lib.mtjava.strings.func.StringConsumer;
import com.mr_toad.lib.mtjava.strings.func.StringSupplier;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class OptionalString {
    private static final OptionalString EMPTY = new OptionalString();
    private final boolean isPresent;
    private final String value;

    private OptionalString() {
        this.isPresent = false;
        this.value = "";
    }

    public static OptionalString empty() {
        return EMPTY;
    }

    private OptionalString(String value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalString of(String value) {
        return new OptionalString(value);
    }

    public static OptionalString ofNullable(@Nullable String value) {
        return value == null ? OptionalString.empty() : OptionalString.of(value);
    }

    public String getAsString() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(StringConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(StringConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public String orElse(String other) {
        return this.isPresent ? this.value : other;
    }

    public String orElseGet(StringSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsString();
    }

    public String orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> String orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Stream<String> stream() {
        if (this.isPresent) {
            return Stream.of(this.value);
        }
        return Stream.empty();
    }

    public Stream<Character> mapToChar(String2CharFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        char s = this.map(mapper).orElse('\u0000');
        return Stream.ofNullable(Character.valueOf(s));
    }

    public OptionalString map(String2StringFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        if (!this.isPresent()) {
            return OptionalString.empty();
        }
        return OptionalString.of(mapper.applyAsString(this.value));
    }

    public OptionalChar map(String2CharFunction mapper) {
        Preconditions.checkNotNull((Object)mapper);
        if (!this.isPresent()) {
            return OptionalChar.empty();
        }
        return OptionalChar.of(mapper.applyAsChar(this.value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalString)) return false;
        OptionalString other = (OptionalString)obj;
        if (this.isPresent && other.isPresent) {
            if (!Objects.equal((Object)this.value, (Object)other.value)) return false;
            return true;
        } else if (this.isPresent != other.isPresent) return false;
        return true;
    }

    public int hashCode() {
        return this.isPresent ? this.value.hashCode() : 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(this.isPresent ? String.format("OptionalString[%s]", this.value) : "Empty", (Object)this.value).toString();
    }
}

