/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.util;

import java.util.List;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;

public class ToadTradeUtils {
    public static final int NOVICE = 1;
    public static final int APPRENTICE = 2;
    public static final int JOURNEYMAN = 3;
    public static final int EXPERT = 4;
    public static final int MASTER = 5;

    public static void addVillagerTrades(VillagerTradesEvent event, int level, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            ((List)event.getTrades().get(level)).add(trade);
        }
    }

    public static void addVillagerTrades(VillagerTradesEvent event, VillagerProfession profession, int level, VillagerTrades.ItemListing ... trades) {
        if (event.getType() == profession) {
            ToadTradeUtils.addVillagerTrades(event, level, trades);
        }
    }

    public static void addWandererTrades(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getGenericTrades().add(trade);
        }
    }

    public static void addRareWandererTrades(WandererTradesEvent event, VillagerTrades.ItemListing ... trades) {
        for (VillagerTrades.ItemListing trade : trades) {
            event.getRareTrades().add(trade);
        }
    }

    public static class NewTrade
    extends BasicItemListing {
        public NewTrade(ItemStack input, ItemStack input2, ItemStack output, int maxTrades, int xp, float priceMulti) {
            super(input, input2, output, maxTrades, xp, priceMulti);
        }

        public NewTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp, float priceMulti) {
            this(new ItemStack((ItemLike)input, inputCount), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_, emeraldCount), maxTrades, xp, priceMulti);
        }

        public NewTrade(Item input, int inputCount, int emeraldCount, int maxTrades, int xp) {
            this(input, inputCount, emeraldCount, maxTrades, xp, 0.15f);
        }

        public NewTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp, float priceMulti) {
            this(new ItemStack((ItemLike)Items.f_42616_, emeraldCount), ItemStack.f_41583_, new ItemStack((ItemLike)output, outputCount), maxTrades, xp, priceMulti);
        }

        public NewTrade(int emeraldCount, Item output, int outputCount, int maxTrades, int xp) {
            this(emeraldCount, output, outputCount, maxTrades, xp, 0.15f);
        }
    }
}

