/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.misc;

import com.mr_toad.lib.api.util.ToadOtherUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ToadlyDataProvider {

    public static abstract class AbstractToadlyAdvancementProvider {
        public static Advancement.Builder getAdvancement(String modid, Advancement parent, ItemLike display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, (Component)Component.m_237115_((String)(modid + "." + name)), (Component)Component.m_237115_((String)(modid + "." + name + ".desc")), null, frame, showToast, announceToChat, hidden);
        }
    }

    public static abstract class AbstractToadlyItemModelProvider
    extends ItemModelProvider {
        public AbstractToadlyItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
            super(output, modid, existingFileHelper);
        }

        public void blockBasedModel(Item item, String suffix, String modid) {
            this.withExistingParent(ToadOtherUtils.itemName(item).orElse(null), ToadOtherUtils.resourceBlock(ToadOtherUtils.itemName(item).orElse(null) + suffix, modid));
        }

        public void itemGeneratedModel(Item item, ResourceLocation texture) {
            ((ItemModelBuilder)this.withExistingParent(ToadOtherUtils.itemName(item).orElse(null), "item/generated")).texture("layer0", texture);
        }
    }

    public static abstract class AbstractToadlyRecipeProvider {
        public static ShapedRecipeBuilder shaped(ItemLike like) {
            return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)like);
        }

        public static SingleItemRecipeBuilder cutting(Ingredient ingredient, ItemLike like) {
            return SingleItemRecipeBuilder.m_245264_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)like);
        }

        public static SimpleCookingRecipeBuilder campfireCoking(Ingredient ingredient, ItemLike like, float f0, int i0) {
            return SimpleCookingRecipeBuilder.m_247020_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)like, (float)f0, (int)i0);
        }

        public static SimpleCookingRecipeBuilder cooking(Ingredient ingredient, ItemLike like, float f0, int i0, RecipeSerializer<? extends AbstractCookingRecipe> recipeSerializer) {
            return SimpleCookingRecipeBuilder.m_247607_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)like, (float)f0, (int)i0, recipeSerializer);
        }
    }

    public static abstract class AbstractToadlyBlockStateProvider
    extends BlockStateProvider {
        public AbstractToadlyBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
            super(output, modid, exFileHelper);
        }

        public void chLogBlock(RotatedPillarBlock block, String name) {
            this.axisBlock(block, this.blockTexture((Block)block), new ResourceLocation("block/" + name + "_log_top"));
        }
    }
}

