/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.entity.entitydata;

import com.mr_toad.lib.api.entity.HybridAttackType;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
public class ToadlyEntityDataSerializers {
    public static final EntityDataSerializer<Double> DOUBLE = EntityDataSerializer.m_238095_(FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble);
    public static final EntityDataSerializer<HybridAttackType> HYBRID_ATTACK_TYPE = EntityDataSerializer.m_238090_(HybridAttackType.class);
    public static final EntityDataSerializer<ResourceLocation> RESOURCE_LOCATION = EntityDataSerializer.m_238095_(FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_);
    public static final EntityDataSerializer<Optional<ResourceLocation>> OPTIONAL_RESOURCE_LOCATION = EntityDataSerializer.m_238098_(FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_);
    public static final EntityDataSerializer<OptionalDouble> OPTIONAL_UNSIGNED_DOUBLE = new EntityDataSerializer.ForValueType<OptionalDouble>(){

        public void write(FriendlyByteBuf buf, OptionalDouble optionalDouble) {
            buf.writeDouble(optionalDouble.orElse(-1.0) + 1.0);
        }

        public OptionalDouble read(FriendlyByteBuf buf) {
            double i = buf.readDouble();
            return i == 0.0 ? OptionalDouble.empty() : OptionalDouble.of(i - 1.0);
        }
    };

    static {
        EntityDataSerializers.m_135050_(HYBRID_ATTACK_TYPE);
        EntityDataSerializers.m_135050_(DOUBLE);
        EntityDataSerializers.m_135050_(RESOURCE_LOCATION);
        EntityDataSerializers.m_135050_(OPTIONAL_RESOURCE_LOCATION);
        EntityDataSerializers.m_135050_(OPTIONAL_UNSIGNED_DOUBLE);
    }
}

