/*
 * Decompiled with CFR 0.152.
 */
package com.mr_toad.lib.api.entity;

import com.mr_toad.lib.api.EndWaterBehaviors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface EndWaterMobInteractive<T extends LivingEntity> {
    public void getEndWaterBehavior(BlockPos var1, Level var2, T var3);

    default public boolean getEndWaterBehaviors(T entity, DamageSource endWaterSource) {
        switch (this.getEndWaterBehavior()) {
            case HURT: {
                this.waterHurt(entity, endWaterSource);
                break;
            }
            case REGEN: {
                this.waterHeal(entity);
                break;
            }
            case INSTANT_DEATH: {
                this.waterKill(entity, endWaterSource);
            }
        }
        return false;
    }

    public EndWaterBehaviors getEndWaterBehavior();

    default public void waterAddEffect(T entity, DamageSource endWaterSource, MobEffect effect, int lvl, int ticks) {
        if (!entity.m_6673_(endWaterSource) && this.getEndWaterBehavior() == EndWaterBehaviors.ADD_EFFECT) {
            entity.m_7292_(new MobEffectInstance(effect, lvl, ticks));
        }
    }

    default public void waterKill(T entity, DamageSource endWaterSource) {
        if (!entity.m_6673_(endWaterSource)) {
            entity.m_6469_(endWaterSource, Float.MAX_VALUE);
        }
    }

    default public void waterHurt(T entity, DamageSource endWaterSource) {
        if (!entity.m_6673_(endWaterSource)) {
            entity.m_6469_(endWaterSource, 1.0f);
        }
    }

    default public void waterHeal(T entity) {
        if (entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(1.0f);
        }
    }
}

