/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.mixin;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.ContainedRemnantItem;
import net.sweenus.simplyswords.item.RunicTabletItem;
import net.sweenus.simplyswords.item.custom.CaelestisSwordItem;
import net.sweenus.simplyswords.item.custom.DormantRelicSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    public void simplyswords$damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            int duration;
            MobEffectInstance astralShiftInstance;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_21023_((MobEffect)EffectRegistry.RESILIENCE.get())) {
                HelperMethods.decrementStatusEffect((LivingEntity)serverPlayer, (MobEffect)EffectRegistry.RESILIENCE.get());
                cir.setReturnValue((Object)false);
                if (!player.m_21023_((MobEffect)EffectRegistry.MAGISLAM.get())) {
                    serverPlayer.m_9236_().m_6269_(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_03.get(), SoundSource.PLAYERS, 0.7f, 0.5f + (float)serverPlayer.m_217043_().m_216332_(1, 5) * 0.1f);
                }
            }
            if (serverPlayer.m_21023_((MobEffect)EffectRegistry.ASTRAL_SHIFT.get()) && (astralShiftInstance = player.m_21124_((MobEffect)EffectRegistry.ASTRAL_SHIFT.get())) != null && (duration = astralShiftInstance.m_19557_()) > 10) {
                HelperMethods.incrementStatusEffect((LivingEntity)serverPlayer, (MobEffect)EffectRegistry.ASTRAL_SHIFT.get(), duration, (int)Math.max(1.0f, amount / 10.0f), 99);
                AbilityMethods.astralShiftSounds(serverPlayer);
                cir.setReturnValue((Object)false);
            }
            if (serverPlayer.m_21205_().m_41720_() instanceof CaelestisSwordItem && AbilityMethods.astralShiftPassive(serverPlayer)) {
                AbilityMethods.astralShiftSounds(serverPlayer);
                cir.setReturnValue((Object)false);
            }
            if (source.toString().contains("sonic_boom")) {
                for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                    ItemStack stackInSlot = serverPlayer.m_150109_().m_8020_(i);
                    if (!stackInSlot.m_150930_((Item)ItemsRegistry.DECAYING_RELIC.get())) continue;
                    ItemStack newItemStack = new ItemStack((ItemLike)ItemsRegistry.MAGISCYTHE.get());
                    serverPlayer.m_150109_().m_6836_(i, newItemStack);
                    serverPlayer.m_9236_().m_6269_(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.m_5720_(), 0.6f, 0.6f);
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.magicythe.event"), true);
                    break;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void simplyswords$tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            int frequency;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_21205_().m_150930_((Item)ItemsRegistry.RIBBONCLEAVER.get()) || serverPlayer.m_21205_().m_150930_((Item)ItemsRegistry.ENIGMA.get())) {
                frequency = 6;
                if (serverPlayer.f_19797_ % 20 == 0 && serverPlayer.m_21205_().m_150930_((Item)ItemsRegistry.RIBBONCLEAVER.get())) {
                    serverPlayer.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.RIBBONWRATH.get(), 30, 0, true, false, false));
                }
                if (player.f_19797_ % frequency == 0 && player.m_20142_() && player.m_20096_()) {
                    float volume = 0.3f;
                    float pitch = 1.0f + (float)player.m_217043_().m_216332_(1, 5) * 0.1f;
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.OBJECT_IMPACT_THUD.get(), SoundSource.PLAYERS, volume, pitch);
                }
            }
            if (serverPlayer.m_21205_().m_150930_((Item)ItemsRegistry.MAGIBLADE.get())) {
                frequency = 8;
                int radius = (int)Config.getFloat("magibladeRepelRadius", "UniqueEffects", ConfigDefaultValues.magibladeRepelRadius);
                int chance = (int)Config.getFloat("magibladeRepelChance", "UniqueEffects", ConfigDefaultValues.magibladeRepelChance);
                int totalChance = new Random().nextInt(100);
                if (serverPlayer.f_19797_ % frequency == 0 && totalChance < chance) {
                    LivingEntity le;
                    AABB box = HelperMethods.createBox((Entity)player, radius);
                    Entity closestEntity = player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_).stream().filter(entity -> {
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            return HelperMethods.checkFriendlyFire(livingEntity, (LivingEntity)player);
                        }
                        return false;
                    }).min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)player))).orElse(null);
                    if (closestEntity != null && closestEntity instanceof LivingEntity && (le = (LivingEntity)closestEntity).m_20270_((Entity)player) > 1.0f) {
                        closestEntity.m_20334_((closestEntity.m_20185_() - player.m_20185_()) / 2.0, 0.0, (closestEntity.m_20189_() - player.m_20189_()) / 2.0);
                        float volume = 0.8f;
                        float pitch = 1.0f + (float)player.m_217043_().m_216332_(1, 5) * 0.1f;
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_144212_, SoundSource.PLAYERS, volume, pitch);
                        HelperMethods.spawnWaistHeightParticles((ServerLevel)player.m_9236_(), (ParticleOptions)ParticleTypes.f_123809_, closestEntity, (Entity)player, 10);
                        HelperMethods.spawnOrbitParticles((ServerLevel)closestEntity.m_9236_(), closestEntity.m_20182_().m_82520_(0.0, (double)(closestEntity.m_20206_() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.f_235900_, 0.5, 6);
                    }
                }
            }
            if (serverPlayer.f_19797_ % (frequency = 6000) == 0) {
                ItemStack containedRemnant = ((ContainedRemnantItem)((Object)ItemsRegistry.CONTAINED_REMNANT.get())).m_5456_().m_7968_();
                ItemStack tamperedRemnant = ((ContainedRemnantItem)((Object)ItemsRegistry.TAMPERED_REMNANT.get())).m_5456_().m_7968_();
                ItemStack decayingRelic = ((DormantRelicSwordItem)((Object)ItemsRegistry.DECAYING_RELIC.get())).m_5456_().m_7968_();
                ItemStack runicTablet = ((RunicTabletItem)((Object)ItemsRegistry.RUNIC_TABLET.get())).m_5456_().m_7968_();
                Random random = new Random();
                TagKey desiredItemsTag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("simplyswords", "conditional_uniques_type_1"));
                TagKey endItemsTag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("simplyswords", "conditional_uniques_type_2"));
                int chance = random.nextInt(100);
                for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                    ItemStack stackInSlot = serverPlayer.m_150109_().m_8020_(i);
                    if ((stackInSlot.m_150930_(containedRemnant.m_41720_()) || stackInSlot.m_150930_(tamperedRemnant.m_41720_())) && chance < 21 && Config.getBoolean("enableContainedRemnants", "Loot", ConfigDefaultValues.enableContainedRemnants)) {
                        List<Item> itemsFromTag = BuiltInRegistries.f_257033_.m_123024_().filter(item -> item.m_7968_().m_204117_(desiredItemsTag)).toList();
                        List<Item> itemsFromTagEnd = BuiltInRegistries.f_257033_.m_123024_().filter(item -> item.m_7968_().m_204117_(endItemsTag)).toList();
                        if (!itemsFromTag.isEmpty() && !itemsFromTagEnd.isEmpty()) {
                            Item randomItem = (Item)ItemsRegistry.TAMPERED_REMNANT.get();
                            if (serverPlayer.m_9236_().m_46472_().equals(Level.f_46430_) && serverPlayer.m_150109_().m_8020_(i).m_150930_(containedRemnant.m_41720_()) && serverPlayer.m_150109_().m_36063_(runicTablet)) {
                                serverPlayer.m_9236_().m_6269_(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), serverPlayer.m_5720_(), 0.3f, 0.6f);
                                serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.contained_remnant.event2"), true);
                            } else {
                                if (serverPlayer.m_150109_().m_8020_(i).m_150930_((Item)ItemsRegistry.CONTAINED_REMNANT.get())) {
                                    randomItem = itemsFromTag.get(random.nextInt(itemsFromTag.size()));
                                } else if (serverPlayer.m_150109_().m_8020_(i).m_150930_((Item)ItemsRegistry.TAMPERED_REMNANT.get())) {
                                    randomItem = itemsFromTagEnd.get(random.nextInt(itemsFromTagEnd.size()));
                                }
                                serverPlayer.m_9236_().m_6269_(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.m_5720_(), 0.3f, 0.6f);
                                serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.contained_remnant.event"), true);
                            }
                            ItemStack newItemStack = new ItemStack((ItemLike)randomItem);
                            serverPlayer.m_150109_().m_6836_(i, newItemStack);
                            break;
                        }
                    }
                    BlockState playerStandingBlock = serverPlayer.m_20075_();
                    if (stackInSlot.m_150930_(decayingRelic.m_41720_()) && playerStandingBlock.m_60713_(Blocks.f_220855_)) {
                        serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.magicythe.event2"), true);
                    }
                    if (!stackInSlot.m_150930_(decayingRelic.m_41720_()) || !playerStandingBlock.m_60713_(Blocks.f_152500_)) continue;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.magiblade.event2"), true);
                }
            }
            if (serverPlayer.f_19797_ % 20 == 0) {
                BlockState playerStandingBlock = serverPlayer.m_20075_();
                ItemStack decayingRelic = ((DormantRelicSwordItem)((Object)ItemsRegistry.DECAYING_RELIC.get())).m_5456_().m_7968_();
                int chance = new Random().nextInt(100);
                for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                    ItemStack newItemStack;
                    ItemStack stackInSlot = serverPlayer.m_150109_().m_8020_(i);
                    if (chance < 15 && playerStandingBlock.m_60713_(Blocks.f_152500_) && stackInSlot.m_150930_(decayingRelic.m_41720_())) {
                        newItemStack = new ItemStack((ItemLike)ItemsRegistry.MAGIBLADE.get());
                        serverPlayer.m_150109_().m_6836_(i, newItemStack);
                        serverPlayer.m_9236_().m_6269_(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.m_5720_(), 0.6f, 0.6f);
                        serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.magiblade.event"), true);
                        break;
                    }
                    if (!stackInSlot.m_150930_(decayingRelic.m_41720_()) || !player.m_21023_(MobEffects.f_216964_)) continue;
                    if (chance < 2) {
                        newItemStack = new ItemStack((ItemLike)ItemsRegistry.MAGISPEAR.get());
                        serverPlayer.m_150109_().m_6836_(i, newItemStack);
                        serverPlayer.m_9236_().m_6269_(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.m_5720_(), 0.6f, 0.6f);
                        serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.magispear.event"), true);
                        break;
                    }
                    if (chance >= 11) continue;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"item.simplyswords.magispear.event2"), true);
                }
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"attack"})
    public void simplyswords$attack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target.m_6097_() && !target.m_7313_((Entity)player)) {
                ServerLevel serverWorld = (ServerLevel)player.m_9236_();
                if (serverPlayer.m_21023_((MobEffect)EffectRegistry.RIBBONCLEAVE.get())) {
                    serverPlayer.m_21195_((MobEffect)EffectRegistry.RIBBONCLEAVE.get());
                    HelperMethods.spawnOrbitParticles(serverWorld, target.m_20182_().m_82520_(0.0, 0.3, 0.0), (ParticleOptions)ParticleTypes.f_123759_, 0.5, 6);
                    HelperMethods.spawnOrbitParticles(serverWorld, target.m_20182_().m_82520_(0.0, 0.5, 0.0), (ParticleOptions)ParticleTypes.f_123808_, 0.5, 6);
                    serverWorld.m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_01.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                }
            }
        }
    }
}

