/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class BattleStandardEntity
extends PathfinderMob {
    public static final Supplier<EntityType<BattleStandardEntity>> TYPE = Suppliers.memoize(() -> EntityType.Builder.m_20704_(BattleStandardEntity::new, (MobCategory)MobCategory.MISC).m_20712_("battlestandard"));
    float abilityDamage = Config.getFloat("righteousStandardDamage", "UniqueEffects", ConfigDefaultValues.righteousStandardDamage);
    float abilityHeal = 3.0f;
    float abilityHealScalingModifier = Config.getFloat("righteousStandardSpellScalingHeal", "UniqueEffects", ConfigDefaultValues.righteousStandardSpellScalingHeal);
    float spellScalingModifier = Config.getFloat("righteousStandardSpellScaling", "UniqueEffects", ConfigDefaultValues.righteousStandardSpellScaling);
    public LivingEntity ownerEntity;
    public String standardType;
    public int decayRate;
    public String positiveEffect;
    public String positiveEffectSecondary;
    public int positiveEffectAmplifier;
    public String negativeEffect;
    public String negativeEffectSecondary;
    public int negativeEffectAmplifier;
    public boolean dealsDamage = true;
    public boolean doesHealing = true;
    private static boolean errorLogged = false;

    public static AttributeSupplier.Builder createBattleStandardAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 100.0);
    }

    public BattleStandardEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    private static void errorCatch(String identifier) {
        if (!errorLogged) {
            System.out.println("ERROR: Identifier " + identifier + " does not match any registered effects.\nDestroying banner entity now.");
            errorLogged = true;
        }
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.ownerEntity == null;
    }

    public void m_6075_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 10 == 0) {
                this.m_21153_(this.m_21223_() - (float)this.decayRate);
                if (this.ownerEntity == null) {
                    this.m_21153_(this.m_21223_() - 1000.0f);
                }
            }
            if (this.ownerEntity != null && this.standardType != null) {
                LivingEntity le;
                AABB box;
                if (!this.ownerEntity.m_6084_()) {
                    this.m_21153_(this.m_21223_() - 1000.0f);
                }
                int radius = 6;
                if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, (Entity)this.ownerEntity, "fire") > 0.0f) {
                    this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, (Entity)this.ownerEntity, "fire");
                }
                if (this.f_19797_ % 10 == 0) {
                    box = new AABB(this.m_20185_() + (double)radius, this.m_20186_() + (double)((float)radius / 3.0f), this.m_20189_() + (double)radius, this.m_20185_() - (double)radius, this.m_20186_() - (double)((float)radius / 3.0f), this.m_20189_() - (double)radius);
                    block28: for (Entity entity : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_)) {
                        if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, this.ownerEntity) || le == this.ownerEntity || le instanceof BattleStandardEntity || le instanceof BattleStandardDarkEntity) continue;
                        block9 : switch (this.standardType) {
                            case "sunfire": {
                                le.m_6469_(this.ownerEntity.m_269291_().m_269425_(), this.abilityDamage);
                                le.m_20254_(1);
                                le.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, 1), (Entity)this);
                                break;
                            }
                            case "nullification": {
                                for (MobEffectInstance statusEffect : le.m_21220_()) {
                                    if (statusEffect == null || !statusEffect.m_19544_().m_19486_()) continue;
                                    le.m_21195_(statusEffect.m_19544_());
                                    break block9;
                                }
                                continue block28;
                            }
                            case "api": {
                                if (this.dealsDamage) {
                                    le.m_6469_(this.ownerEntity.m_269291_().m_269425_(), this.abilityDamage);
                                }
                                if (this.negativeEffect != null) {
                                    try {
                                        le.m_147207_(new MobEffectInstance((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(this.negativeEffect)), 20, this.negativeEffectAmplifier), (Entity)this);
                                    }
                                    catch (Exception e) {
                                        BattleStandardEntity.errorCatch(this.negativeEffect);
                                        this.m_21153_(this.m_21223_() - 1000.0f);
                                    }
                                }
                                if (this.negativeEffectSecondary == null) break;
                                try {
                                    le.m_147207_(new MobEffectInstance((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(this.negativeEffectSecondary)), 20, this.negativeEffectAmplifier), (Entity)this);
                                    break;
                                }
                                catch (Exception e) {
                                    BattleStandardEntity.errorCatch(this.negativeEffectSecondary);
                                    this.m_21153_(this.m_21223_() - 1000.0f);
                                }
                            }
                        }
                    }
                    HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
                if (this.m_21223_() > this.m_21233_() - 2.0f && this.m_20096_()) {
                    HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.3, 0.0);
                    HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.1, 0.0);
                    box = new AABB(this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0, this.m_20185_() - 1.0, this.m_20186_() - 1.0, this.m_20189_() - 1.0);
                    for (Entity entity : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_)) {
                        if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, this.ownerEntity) || le == this.ownerEntity) continue;
                        le.m_6469_(this.ownerEntity.m_269291_().m_269425_(), this.abilityDamage * 3.0f);
                        le.m_20254_(1);
                        le.m_20334_((le.m_20185_() - this.m_20185_()) / 4.0, 0.5, (le.m_20189_() - this.m_20189_()) / 4.0);
                    }
                }
                if (this.f_19797_ % 80 == 0) {
                    box = new AABB(this.m_20185_() + (double)radius, this.m_20186_() + (double)((float)radius / 3.0f), this.m_20189_() + (double)radius, this.m_20185_() - (double)radius, this.m_20186_() - (double)((float)radius / 3.0f), this.m_20189_() - (double)radius);
                    block31: for (Entity entities : this.m_9236_().m_6249_((Entity)this, box, EntitySelector.f_20403_)) {
                        if (!(entities instanceof LivingEntity) || HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, this.ownerEntity)) continue;
                        if (HelperMethods.commonSpellAttributeScaling(this.abilityHealScalingModifier, (Entity)this.ownerEntity, "healing") > 0.0f) {
                            this.abilityHeal = HelperMethods.commonSpellAttributeScaling(this.abilityHealScalingModifier, (Entity)this.ownerEntity, "healing");
                        }
                        block19 : switch (this.standardType) {
                            case "sunfire": {
                                le.m_5634_(this.abilityHeal);
                                le.m_147207_(new MobEffectInstance(MobEffects.f_19600_, 90, 1), (Entity)this);
                                break;
                            }
                            case "nullification": {
                                for (MobEffectInstance statusEffect : le.m_21220_()) {
                                    if (statusEffect == null || statusEffect.m_19544_().m_19486_() || Objects.equals(statusEffect.m_19544_(), EffectRegistry.BATTLE_FATIGUE.get())) continue;
                                    le.m_21195_(statusEffect.m_19544_());
                                    break block19;
                                }
                                continue block31;
                            }
                            case "api": {
                                if (this.doesHealing) {
                                    le.m_5634_(this.abilityHeal);
                                }
                                if (this.positiveEffect != null) {
                                    try {
                                        le.m_147207_(new MobEffectInstance((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(this.positiveEffect)), 85, this.positiveEffectAmplifier), (Entity)this);
                                    }
                                    catch (Exception e) {
                                        BattleStandardEntity.errorCatch(this.positiveEffect);
                                        this.m_21153_(this.m_21223_() - 1000.0f);
                                    }
                                }
                                if (this.positiveEffectSecondary == null) break;
                                try {
                                    le.m_147207_(new MobEffectInstance((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(this.positiveEffectSecondary)), 85, this.positiveEffectAmplifier), (Entity)this);
                                    break;
                                }
                                catch (Exception e) {
                                    BattleStandardEntity.errorCatch(this.positiveEffectSecondary);
                                    this.m_21153_(this.m_21223_() - 1000.0f);
                                }
                            }
                        }
                    }
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_02.get(), this.m_5720_(), 0.1f, 0.6f);
                    double xpos = this.m_20185_() - (double)(radius + 1);
                    double ypos = this.m_20186_();
                    double zpos = this.m_20189_() - (double)(radius + 1);
                    for (int i = radius * 2; i > 0; --i) {
                        for (int j = radius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            if (!((double)choose > 0.5)) continue;
                            HelperMethods.spawnParticle(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, -0.1, 0.0);
                        }
                    }
                }
            }
        }
        super.m_6075_();
    }
}

