/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsVillagerRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class RatlantisTeleporter
implements ITeleporter {
    protected final ServerLevel level;

    public RatlantisTeleporter(ServerLevel level) {
        this.level = level;
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(BlockPos pos) {
        PoiManager manager = this.level.m_8904_();
        manager.m_27056_((LevelReader)this.level, pos, 32);
        Optional<PoiRecord> optional = manager.m_27166_(type -> type.m_203565_(RatsVillagerRegistry.RATLANTIS_PORTAL.getKey()), pos, 32, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).filter(poi -> this.level.m_8055_(poi.m_27257_()).m_60713_((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get())).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            this.level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)Direction.Axis.Y, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.level.m_8055_(posIn) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!this.level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) {
            this.level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        }
        pos = this.level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos).m_7494_();
        this.level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        this.level.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
        BlockPos portalBottom = pos.m_7918_(1, -1, 1);
        for (BlockPos currentPos : BlockPos.m_121990_((BlockPos)portalBottom.m_7918_(-2, 0, -2), (BlockPos)portalBottom.m_7918_(2, 0, 2)).map(BlockPos::m_7949_).toList()) {
            this.setBlockIfReplaceableSpot(currentPos, ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_TILE.get()).m_49966_());
            this.setBlockIfReplaceableSpot(currentPos.m_6630_(4), ((Block)RatlantisBlockRegistry.MARBLED_CHEESE_TILE.get()).m_49966_());
        }
        for (int i = 1; i < 4; ++i) {
            this.setBlockIfReplaceableSpot(portalBottom.m_7918_(2, 0, 2).m_6630_(i), (BlockState)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y));
            this.setBlockIfReplaceableSpot(portalBottom.m_7918_(2, 0, -2).m_6630_(i), (BlockState)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y));
            this.setBlockIfReplaceableSpot(portalBottom.m_7918_(-2, 0, 2).m_6630_(i), (BlockState)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y));
            this.setBlockIfReplaceableSpot(portalBottom.m_7918_(-2, 0, -2).m_6630_(i), (BlockState)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y));
        }
        this.level.m_46597_(portalBottom, ((Block)RatsBlockRegistry.MARBLED_CHEESE_RAW.get()).m_49966_());
        this.level.m_46597_(portalBottom.m_7494_(), ((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get()).m_49966_());
        this.level.m_46597_(portalBottom.m_6630_(2), ((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get()).m_49966_());
        this.level.m_46597_(portalBottom.m_6630_(3), ((Block)RatsBlockRegistry.MARBLED_CHEESE_RAW.get()).m_49966_());
        return Optional.of(new BlockUtil.FoundRectangle(portalBottom.m_7918_(-1, 1, -1), 1, 2));
    }

    private void setBlockIfReplaceableSpot(BlockPos pos, BlockState state) {
        if (this.level.m_8055_(pos).m_60795_() || this.level.m_8055_(pos).m_247087_() && this.level.m_6425_(pos).m_76178_() || this.level.m_8055_(pos).m_60800_((BlockGetter)this.level, pos) >= 0.0f && this.level.m_8055_(pos).m_60800_((BlockGetter)this.level, pos) < 10.0f) {
            this.level.m_46597_(pos, state);
        }
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel level, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        boolean ratlantis;
        boolean bl = ratlantis = level.m_46472_() == RatlantisDimensionRegistry.DIMENSION_KEY;
        if (entity.m_9236_().m_46472_() != RatlantisDimensionRegistry.DIMENSION_KEY && !ratlantis) {
            return null;
        }
        WorldBorder border = level.m_6857_();
        double minX = Math.max(-2.9999872E7, border.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, border.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.m_61958_() - 16.0);
        double coordinateDifference = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)level.m_6042_());
        BlockPos blockpos = BlockPos.m_274561_((double)Mth.m_14008_((double)(entity.m_20185_() * coordinateDifference), (double)minX, (double)maxX), (double)entity.m_20186_(), (double)Mth.m_14008_((double)(entity.m_20189_() * coordinateDifference), (double)minZ, (double)maxZ));
        return this.getOrMakePortal(blockpos).map(result -> {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState state = entity.m_9236_().m_8055_(entity.f_19819_);
            if (state.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle rectangle = BlockUtil.m_124334_((BlockPos)entity.f_19819_, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.m_9236_().m_8055_(pos) == state);
                vector3d = PortalShape.m_77738_((BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)entity.m_20182_(), (EntityDimensions)entity.m_6972_(entity.m_20089_()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)level, (BlockUtil.FoundRectangle)result, (Direction.Axis)axis, (Vec3)vector3d, (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    protected Optional<BlockUtil.FoundRectangle> getOrMakePortal(BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        return this.makePortal(pos);
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return false;
    }
}

