/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.server.world.RatlantisRuinConfiguration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class RatlantisRuinFeature
extends Feature<RatlantisRuinConfiguration> {
    public RatlantisRuinFeature(Codec<RatlantisRuinConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RatlantisRuinConfiguration> context) {
        RandomSource random = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos blockpos = context.m_159777_();
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        RatlantisRuinConfiguration config = (RatlantisRuinConfiguration)context.m_159778_();
        StructureTemplateManager structuretemplatemanager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate structuretemplate = null;
        ArrayList<ResourceLocation> shuffledList = new ArrayList<ResourceLocation>(config.ruins().keySet());
        Collections.shuffle(shuffledList);
        for (ResourceLocation entry : shuffledList) {
            if (!(random.m_188501_() < config.ruins().get(entry).floatValue())) continue;
            structuretemplate = structuretemplatemanager.m_230359_(entry);
            break;
        }
        if (structuretemplate == null) {
            structuretemplate = structuretemplatemanager.m_230359_(config.defaultRuin());
        }
        ChunkPos chunkpos = new ChunkPos(blockpos);
        BoundingBox boundingbox = new BoundingBox(chunkpos.m_45604_() - 16, level.m_141937_(), chunkpos.m_45605_() - 16, chunkpos.m_45608_() + 16, level.m_151558_(), chunkpos.m_45609_() + 16);
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74379_(rotation).m_74381_(boundingbox).m_230324_(random);
        Vec3i vec3i = structuretemplate.m_163808_(rotation);
        BlockPos blockpos1 = blockpos.m_7918_(-vec3i.m_123341_() / 2, 0, -vec3i.m_123343_() / 2);
        BlockPos blockpos2 = structuretemplate.m_74583_(blockpos1, Mirror.NONE, rotation);
        if (!level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)level, blockpos2)) {
            return false;
        }
        structureplacesettings.m_74394_();
        ((StructureProcessorList)config.processor().get()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        return structuretemplate.m_230328_((ServerLevelAccessor)level, blockpos2, blockpos2, structureplacesettings, random, 20);
    }
}

