/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.registry.worldgen.RatlantisFeatureRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class CopyInputStateRuleProcessor
extends StructureProcessor {
    public static final Codec<CopyInputStateRuleProcessor> CODEC = ProcessorRule.f_74215_.listOf().fieldOf("rules").xmap(CopyInputStateRuleProcessor::new, config -> config.rules).codec();
    private final ImmutableList<ProcessorRule> rules;

    public CopyInputStateRuleProcessor(List<? extends ProcessorRule> list) {
        this.rules = ImmutableList.copyOf(list);
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader reader, BlockPos oldPos, BlockPos newPos, StructureTemplate.StructureBlockInfo oldInfo, StructureTemplate.StructureBlockInfo newInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        RandomSource randomsource = RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)newInfo.f_74675_()));
        BlockState blockstate = reader.m_8055_(newInfo.f_74675_());
        for (ProcessorRule processorrule : this.rules) {
            if (!processorrule.m_230309_(newInfo.f_74676_(), blockstate, oldInfo.f_74675_(), newInfo.f_74675_(), newPos, randomsource)) continue;
            return new StructureTemplate.StructureBlockInfo(newInfo.f_74675_(), processorrule.m_74237_().m_60734_().m_152465_(oldInfo.f_74676_()), processorrule.m_276991_(randomsource, newInfo.f_74677_()));
        }
        return newInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)RatlantisFeatureRegistry.COPY_STATE.get();
    }
}

