/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RatTreeUtils {
    public static final HashMap<BlockPos, Integer> highestleaf = new HashMap();
    private static final HashMap<BlockPos, Integer> rgnbmcount = new HashMap();

    public static int calculateLogAmount(Level level, BlockPos pos) {
        highestleaf.put(pos, 0);
        int leafcount = 8;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() - 2), (int)(pos.m_123341_() + 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() + 2)).iterator();
            while (it.hasNext()) {
                BlockPos currentPos = (BlockPos)it.next();
                BlockState currentState = level.m_8055_(currentPos);
                if (RatTreeUtils.isTreeLeaf(currentState)) {
                    --leafcount;
                    if (currentPos.m_123342_() <= highesty) continue;
                    highesty = currentPos.m_123342_();
                    continue;
                }
                if (!RatTreeUtils.isTreeLog(currentState)) continue;
                ++logcount;
            }
        }
        highestleaf.put(pos.m_7949_(), highesty);
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    public static List<BlockPos> getAllStumpBlocks(Level level, BlockPos pos, BlockState logtype) {
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        BlockState blockbelow = level.m_8055_(pos.m_7495_());
        if (blockbelow.m_204336_(BlockTags.f_144274_)) {
            Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)pos.m_123342_(), (int)(pos.m_123343_() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                BlockState block = level.m_8055_(npos);
                if (!logtype.m_60713_(block.m_60734_()) && !RatTreeUtils.areEqualLogTypes(logtype, block)) continue;
                bottomlogs.add(npos.m_7949_());
            }
        }
        return bottomlogs;
    }

    @Nullable
    public static Block getSaplingFromLeaves(ServerLevel level, Block leaves) {
        try {
            LootTable loot = level.m_7654_().m_278653_().m_278676_(leaves.m_60589_());
            LootParams.Builder context = new LootParams.Builder(level).m_287286_(LootContextParams.f_81463_, (Object)RatTreeUtils.createMaxHoe()).m_287286_(LootContextParams.f_81461_, (Object)leaves.m_49966_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.f_82478_).m_287239_(Float.MAX_VALUE);
            for (int i = 0; i < 25; ++i) {
                ObjectArrayList lootStacks = loot.m_287195_(context.m_287235_(LootContextParamSets.f_81421_));
                for (ItemStack stack : lootStacks) {
                    if (!ForgeRegistries.ITEMS.tags().getTag(ItemTags.f_13180_).contains((Object)stack.m_41720_()) && !(Block.m_49814_((Item)stack.m_41720_()) instanceof SaplingBlock)) continue;
                    return Block.m_49814_((Item)stack.m_41720_());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static ItemStack createMaxHoe() {
        ItemStack hoe = new ItemStack((ItemLike)Items.f_42397_);
        hoe.m_41663_(Enchantments.f_44987_, 127);
        return hoe;
    }

    public static List<BlockPos> getLogsToBreak(Level level, BlockPos pos, List<BlockPos> logsToBreak, BlockState logType) {
        ArrayList<BlockPos> checkAround = new ArrayList<BlockPos>();
        boolean isMangrove = RatTreeUtils.isMangroveRootOrLog(logType);
        int downY = pos.m_123342_() - 1;
        ArrayList<BlockPos> aroundLogs = new ArrayList<BlockPos>();
        for (BlockPos posToCheck : BlockPos.m_121976_((int)(pos.m_123341_() - 1), (int)(pos.m_123342_() - 1), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() + 1), (int)(pos.m_123343_() + 1))) {
            aroundLogs.add(posToCheck.m_7949_());
        }
        for (BlockPos aroundLogPos : aroundLogs) {
            BlockState logstate;
            if (logsToBreak.contains(aroundLogPos) || !(logstate = level.m_8055_(aroundLogPos)).equals(logType) && !RatTreeUtils.areEqualLogTypes(logType, logstate)) continue;
            if (!isMangrove || aroundLogPos.m_123342_() != downY) {
                checkAround.add(aroundLogPos);
            }
            logsToBreak.add(aroundLogPos);
        }
        if (checkAround.isEmpty()) {
            return logsToBreak;
        }
        for (BlockPos capos : checkAround) {
            for (BlockPos logpos : RatTreeUtils.getLogsToBreak(level, capos, logsToBreak, logType)) {
                if (logsToBreak.contains(logpos)) continue;
                logsToBreak.add(logpos.m_7949_());
            }
        }
        BlockPos up = pos.m_6630_(2);
        return RatTreeUtils.getLogsToBreak(level, up.m_7949_(), logsToBreak, logType);
    }

    public static Pair<Integer, Integer> getHorizontalAndVerticalValue(int logcount) {
        int h = 5;
        int v = 5;
        if (logcount >= 20) {
            h = 8;
            v = 8;
        } else if (logcount >= 15) {
            h = 7;
            v = 7;
        } else if (logcount >= 10) {
            h = 6;
        }
        return new Pair((Object)h, (Object)v);
    }

    public static Pair<Boolean, List<BlockPos>> isConnectedToLogs(Level level, BlockPos startpos) {
        List<BlockPos> recursiveList = RatTreeUtils.getBlocksNextToEachOtherMaterial(level, startpos, 6);
        for (BlockPos connectedpos : recursiveList) {
            BlockState connectedblock = level.m_8055_(connectedpos);
            if (!RatTreeUtils.isTreeLog(connectedblock)) continue;
            return new Pair((Object)true, recursiveList);
        }
        return new Pair((Object)false, recursiveList);
    }

    public static boolean isTreeLog(BlockState block) {
        return block.m_204336_(BlockTags.f_13106_) || RatTreeUtils.isTreeRoot(block);
    }

    public static boolean areEqualLogTypes(BlockState one, BlockState two) {
        if (!RatTreeUtils.isTreeLog(one) || !RatTreeUtils.isTreeLog(two)) {
            return false;
        }
        if (RatTreeUtils.isMangroveRootOrLog(one) && RatTreeUtils.isMangroveRootOrLog(two)) {
            return true;
        }
        return one.m_60713_(two.m_60734_());
    }

    public static boolean isTreeRoot(BlockState block) {
        return block.m_60734_() instanceof MangroveRootsBlock;
    }

    public static boolean isMangroveRootOrLog(BlockState block) {
        return block.m_60734_() instanceof MangroveRootsBlock || block.m_204336_(BlockTags.f_215840_);
    }

    public static boolean isTreeLeaf(BlockState block) {
        return block.m_204336_(BlockTags.f_13035_) || block.m_204336_(BlockTags.f_13078_) || block.m_60713_(Blocks.f_50701_);
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(Level level, BlockPos startpos, int maxDistance) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (level.m_8055_(startpos).m_204336_(BlockTags.f_13106_) || level.m_8055_(startpos).m_204336_(BlockTags.f_13035_)) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbmcount.put(startpos.m_7949_(), 0);
        RatTreeUtils.recursiveGetNextBlocksMaterial(level, startpos, startpos, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(Level level, BlockPos startpos, BlockPos pos, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks, int maxDistance) {
        int rgnbmc = rgnbmcount.get(startpos);
        if (rgnbmc > 100) {
            return;
        }
        rgnbmcount.put(startpos, rgnbmc + 1);
        for (Direction dir : Direction.values()) {
            BlockPos pba = pos.m_121945_(dir);
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!level.m_8055_(pba).m_204336_(BlockTags.f_13106_) && !level.m_8055_(pba).m_204336_(BlockTags.f_13035_) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!startpos.m_123314_((Vec3i)pba, (double)maxDistance)) continue;
            RatTreeUtils.recursiveGetNextBlocksMaterial(level, startpos, pba, theblocksaround, checkedblocks, maxDistance);
        }
    }
}

