/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RatPathingHelper {
    public static boolean canSeeOrDigToBlock(DiggingRat rat, BlockPos destination) {
        BlockHitResult result = RatPathingHelper.clipWithConditions((BlockGetter)rat.m_9236_(), new ClipContext(rat.m_20182_(), Vec3.m_82512_((Vec3i)destination), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)rat), !rat.isOnDiggingCooldown());
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean canSeeBlock(AbstractRat rat, BlockPos destination) {
        BlockHitResult result = RatPathingHelper.clipWithConditions((BlockGetter)rat.m_9236_(), new ClipContext(rat.m_20182_(), Vec3.m_82512_((Vec3i)destination), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)rat), false);
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public static BlockHitResult clipWithConditions(BlockGetter getter, ClipContext ctx, boolean ignoreDiggables) {
        return RatPathingHelper.traverseBlocks(ctx.m_45702_(), ctx.m_45693_(), ctx, (context, pos) -> {
            BlockState blockstate = getter.m_8055_(pos);
            FluidState fluidstate = getter.m_6425_(pos);
            Vec3 vec3 = context.m_45702_();
            Vec3 vec31 = context.m_45693_();
            VoxelShape voxelshape = RatPathingHelper.shouldIgnoreBlockDuringTracing(getter, pos, ignoreDiggables) ? Shapes.m_83040_() : context.m_45694_(blockstate, getter, pos);
            BlockHitResult blockhitresult = RatPathingHelper.clipWithInteractionOverride(getter, vec3, vec31, pos, voxelshape, blockstate);
            VoxelShape voxelshape1 = context.m_45698_(fluidstate, getter, pos);
            BlockHitResult blockhitresult1 = voxelshape1.m_83220_(vec3, vec31, pos);
            double d0 = blockhitresult == null ? Double.MAX_VALUE : context.m_45702_().m_82557_(blockhitresult.m_82450_());
            double d1 = blockhitresult1 == null ? Double.MAX_VALUE : context.m_45702_().m_82557_(blockhitresult1.m_82450_());
            return d0 <= d1 ? blockhitresult : blockhitresult1;
        }, context -> {
            Vec3 vec3 = context.m_45702_().m_82546_(context.m_45693_());
            return BlockHitResult.m_82426_((Vec3)context.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)context.m_45693_()));
        });
    }

    @Nullable
    private static BlockHitResult clipWithInteractionOverride(BlockGetter getter, Vec3 toVec, Vec3 fromVec, BlockPos pos, VoxelShape shape, BlockState state) {
        BlockHitResult blockhitresult1;
        BlockHitResult blockhitresult = shape.m_83220_(toVec, fromVec, pos);
        if (blockhitresult != null && (blockhitresult1 = state.m_60820_(getter, pos).m_83220_(toVec, fromVec, pos)) != null && blockhitresult1.m_82450_().m_82546_(toVec).m_82556_() < blockhitresult.m_82450_().m_82546_(toVec).m_82556_()) {
            return blockhitresult.m_82432_(blockhitresult1.m_82434_());
        }
        return blockhitresult;
    }

    private static <T, C> T traverseBlocks(Vec3 toVec, Vec3 fromVec, C context, BiFunction<C, BlockPos, T> posCtxFunction, Function<C, T> ctxFunction) {
        int k;
        int j;
        if (toVec.equals((Object)fromVec)) {
            return ctxFunction.apply(context);
        }
        double d0 = Mth.m_14139_((double)-1.0E-7, (double)fromVec.f_82479_, (double)toVec.f_82479_);
        double d1 = Mth.m_14139_((double)-1.0E-7, (double)fromVec.f_82480_, (double)toVec.f_82480_);
        double d2 = Mth.m_14139_((double)-1.0E-7, (double)fromVec.f_82481_, (double)toVec.f_82481_);
        double d3 = Mth.m_14139_((double)-1.0E-7, (double)toVec.f_82479_, (double)fromVec.f_82479_);
        double d4 = Mth.m_14139_((double)-1.0E-7, (double)toVec.f_82480_, (double)fromVec.f_82480_);
        double d5 = Mth.m_14139_((double)-1.0E-7, (double)toVec.f_82481_, (double)fromVec.f_82481_);
        int i = Mth.m_14107_((double)d3);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(i, j = Mth.m_14107_((double)d4), k = Mth.m_14107_((double)d5));
        T t = posCtxFunction.apply(context, (BlockPos)blockpos$mutableblockpos);
        if (t != null) {
            return t;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = Mth.m_14205_((double)d6);
        int i1 = Mth.m_14205_((double)d7);
        int j1 = Mth.m_14205_((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.m_14185_((double)d3) : Mth.m_14185_((double)d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.m_14185_((double)d4) : Mth.m_14185_((double)d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.m_14185_((double)d5) : Mth.m_14185_((double)d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = posCtxFunction.apply(context, (BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k))) == null) continue;
            return t1;
        }
        return ctxFunction.apply(context);
    }

    private static boolean canDigBlock(BlockGetter getter, BlockPos pos) {
        return getter.m_8055_(pos).m_204336_(RatsBlockTags.DIGGABLE_BLOCKS) && getter.m_8055_(pos).m_60804_(getter, pos);
    }

    private static boolean shouldIgnoreBlockDuringTracing(BlockGetter getter, BlockPos pos, boolean ignoreDiggables) {
        return getter.m_8055_(pos).m_60713_((Block)RatsBlockRegistry.RAT_HOLE.get()) || ignoreDiggables && RatPathingHelper.canDigBlock(getter, pos);
    }
}

