/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class PlaneRotationUtil {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    private boolean compareDouble(double a, double b) {
        double c = a - b;
        return Math.abs(c - 1.0) <= 3.0;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.f_20883_, entity.f_20884_) && Mth.m_14154_((float)this.yawVariation) < maxAngle) {
            this.yawVariation += Mth.m_14036_((float)((entity.f_20884_ - entity.f_20883_) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (Mth.m_14154_((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (Mth.m_14154_((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainPitchBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (!this.compareDouble(entity.m_146909_(), entity.f_19860_) && Mth.m_14154_((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += Mth.m_14036_((float)((entity.f_19860_ - entity.m_146909_()) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (Mth.m_14154_((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = angleDecrement;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (Mth.m_14154_((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = angleDecrement;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (Math.abs(entity.m_146909_()) > maxAngle) {
            return;
        }
        if (!this.compareDouble(entity.m_146909_(), entity.f_19860_) && Mth.m_14154_((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += Mth.m_14036_((float)((entity.f_19860_ - entity.m_146909_()) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (Mth.m_14154_((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (Mth.m_14154_((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.f_20883_, entity.f_20884_) && Mth.m_14154_((float)this.yawVariation) < maxAngle) {
            this.yawVariation += Mth.m_14036_((float)((entity.f_20884_ - entity.f_20883_) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (Mth.m_14154_((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (Mth.m_14154_((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainFlapBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.m_14179_((float)this.prevYawVariation, (float)this.yawVariation, (float)Minecraft.m_91087_().getPartialTick()) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleY += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.m_14179_((float)this.prevPitchVariation, (float)this.pitchVariation, (float)Minecraft.m_91087_().getPartialTick()) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleX += rotateAmount;
        }
    }

    public void applyChainFlapBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleZ += rotateAmount;
        }
    }

    public void applyChainFlapBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleZ -= rotateAmount * 0.5f;
        }
    }

    public void applyChainSwingBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleY -= rotateAmount;
        }
    }

    public void applyChainWaveBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)this.prevPitchVariation, (float)this.pitchVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleX -= rotateAmount;
        }
    }
}

