/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.items.upgrades.MobFilterUpgradeItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record UpdateMobFilterPacket(InteractionHand hand, boolean whitelist, List<String> mobs) {
    public static UpdateMobFilterPacket decode(FriendlyByteBuf buf) {
        return new UpdateMobFilterPacket(buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, buf.readBoolean(), buf.m_236845_(FriendlyByteBuf::m_130277_));
    }

    public static void encode(UpdateMobFilterPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.hand() == InteractionHand.MAIN_HAND);
        buf.writeBoolean(packet.whitelist());
        buf.m_236828_(packet.mobs(), FriendlyByteBuf::m_130070_);
    }

    public static class Handler {
        public static void handle(UpdateMobFilterPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && player.m_21120_(packet.hand()).m_41720_() instanceof MobFilterUpgradeItem) {
                    ItemStack stack = player.m_21120_(packet.hand());
                    MobFilterUpgradeItem.setWhitelist(stack, packet.whitelist());
                    MobFilterUpgradeItem.setMobs(stack, packet.mobs());
                }
            });
        }
    }
}

