/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.projectile.ThrownBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record SyncThrownBlockPacket(int blockEntityId, long blockPos) {
    public static SyncThrownBlockPacket decode(FriendlyByteBuf buf) {
        return new SyncThrownBlockPacket(buf.readInt(), buf.readLong());
    }

    public static void encode(SyncThrownBlockPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.blockEntityId());
        buf.writeLong(packet.blockPos());
    }

    public static class Handler {
        public static void handle(SyncThrownBlockPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.blockEntityId())) instanceof ThrownBlock) {
                    ThrownBlock blocc = (ThrownBlock)entity;
                    BlockPos pos = BlockPos.m_122022_((long)packet.blockPos());
                    blocc.setHeldBlockState(player.m_9236_().m_8055_(pos));
                }
                ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            });
        }
    }
}

