/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record SyncRatTagPacket(int ratId, List<GlobalPos> nodes) {
    public static SyncRatTagPacket decode(FriendlyByteBuf buf) {
        return new SyncRatTagPacket(buf.readInt(), buf.m_236845_(FriendlyByteBuf::m_236872_));
    }

    public static void encode(SyncRatTagPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.ratId());
        buf.m_236828_(packet.nodes(), FriendlyByteBuf::m_236814_);
    }

    public static class Handler {
        public static void handle(SyncRatTagPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.ratId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)entity;
                    rat.getPatrolNodes().clear();
                    rat.getPatrolNodes().addAll(packet.nodes());
                    rat.m_7380_(new CompoundTag());
                }
            });
        }
    }
}

