/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record DismountRatPacket(int ratId) {
    public static DismountRatPacket decode(FriendlyByteBuf buf) {
        return new DismountRatPacket(buf.readInt());
    }

    public static void encode(DismountRatPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.ratId());
    }

    public static class Handler {
        public static void handle(DismountRatPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.ratId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)entity;
                    rat.m_8127_();
                    Vec3 dismountPos = rat.m_7688_((LivingEntity)player);
                    rat.m_6034_(dismountPos.m_7096_(), dismountPos.m_7098_(), dismountPos.m_7094_());
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

