/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.ai.goal.RatDepositGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatPickupGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesAIUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesOverlayUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyRatUpgradeItem
extends BaseRatUpgradeItem
implements ChangesOverlayUpgrade,
ChangesAIUpgrade,
TickRatUpgrade {
    private final int transferRate;
    private final int chargeRate;

    public EnergyRatUpgradeItem(Item.Properties properties, int rarity, int transferRate, int itemChargeRate) {
        super(properties, rarity, 0);
        this.transferRate = transferRate;
        this.chargeRate = itemChargeRate;
    }

    public int getRFTransferRate() {
        return this.transferRate;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_upgrade.energy_desc0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_upgrade.energy_desc1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.rats.rat_upgrade.energy_transfer_rate", (Object[])new Object[]{this.transferRate}).m_130940_(ChatFormatting.GRAY));
        if (RatConfig.ratsChargeHeldItems) {
            tooltip.add((Component)Component.m_237110_((String)"item.rats.rat_upgrade.energy_charge_rate", (Object[])new Object[]{this.chargeRate}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    @Nullable
    public RenderType getOverlayTexture(ItemStack stack, TamedRat rat, float partialTicks) {
        float f = (float)rat.f_19797_ + partialTicks;
        return rat.getHeldRF() > 0 ? RenderType.m_110436_((ResourceLocation)new ResourceLocation("rats", "textures/entity/psychic.png"), (float)(f * 0.01f), (float)(f * 0.01f)) : null;
    }

    @Override
    public List<Goal> addNewWorkGoals(TamedRat rat) {
        return List.of(new RatPickupGoal(rat, RatPickupGoal.PickupType.ENERGY), new RatDepositGoal(rat, RatDepositGoal.DepositType.ENERGY));
    }

    @Override
    public void tick(TamedRat rat) {
        IEnergyStorage energyStorage;
        ItemStack stack;
        LazyOptional optional;
        if (RatConfig.ratsChargeHeldItems && rat.getHeldRF() > 0 && !rat.m_21205_().m_41619_() && (optional = (stack = rat.m_21205_()).getCapability(ForgeCapabilities.ENERGY)).resolve().isPresent() && (energyStorage = (IEnergyStorage)optional.resolve().get()).getEnergyStored() < energyStorage.getMaxEnergyStored()) {
            int energyToTransfer = Math.min(rat.getHeldRF(), this.chargeRate);
            energyToTransfer = energyStorage.receiveEnergy(energyToTransfer, false);
            rat.setHeldRF(Math.max(0, rat.getHeldRF() - energyToTransfer));
        }
    }
}

