/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;

public class EnchanterRatUpgradeItem
extends BaseRatUpgradeItem
implements TickRatUpgrade {
    public EnchanterRatUpgradeItem(Item.Properties properties, int rarity, int textLength) {
        super(properties, rarity, textLength);
    }

    @Override
    public void tick(TamedRat rat) {
        if (!rat.m_21205_().m_41619_()) {
            this.tryEnchanting(rat, this == RatsItemRegistry.RAT_UPGRADE_DISENCHANTER.get());
            this.createFinishedParticles(rat, (ParticleOptions)ParticleTypes.f_123809_, 2, (ParticleOptions)ParticleTypes.f_123762_, 0.0f);
        }
    }

    private void tryEnchanting(TamedRat rat, boolean disenchant) {
        ItemStack heldItem = rat.m_21205_();
        ItemStack burntItem = ItemStack.f_41583_;
        if (heldItem.m_41720_() == Items.f_42517_ && !disenchant) {
            burntItem = heldItem.m_41777_();
        }
        if (heldItem.m_41720_() == Items.f_42690_ && disenchant) {
            burntItem = new ItemStack((ItemLike)Items.f_42517_, heldItem.m_41613_());
        }
        if (heldItem.m_41792_() && !disenchant && !heldItem.m_41793_()) {
            burntItem = heldItem.m_41777_();
        }
        if (disenchant && heldItem.m_41793_()) {
            burntItem = heldItem.m_41777_();
            burntItem.m_41785_().clear();
        }
        if (burntItem.m_41619_()) {
            rat.cookingProgress = 0;
        } else {
            ++rat.cookingProgress;
            if (rat.cookingProgress == 1000) {
                heldItem.m_41774_(1);
                if (!disenchant) {
                    float power = 0.0f;
                    for (BlockPos blockpos : EnchantmentTableBlock.f_207902_) {
                        if (!EnchantmentTableBlock.m_207909_((Level)rat.m_9236_(), (BlockPos)rat.m_20183_(), (BlockPos)blockpos)) continue;
                        power += rat.m_9236_().m_8055_(rat.m_20183_().m_121955_((Vec3i)blockpos)).getEnchantPowerBonus((LevelReader)rat.m_9236_(), rat.m_20183_().m_121955_((Vec3i)blockpos));
                    }
                    burntItem = EnchantmentHelper.m_220292_((RandomSource)rat.m_217043_(), (ItemStack)burntItem, (int)((int)(2.0f + (float)rat.m_217043_().m_188503_(2) + power)), (boolean)false);
                }
                if (heldItem.m_41619_()) {
                    rat.m_21008_(InteractionHand.MAIN_HAND, burntItem);
                } else if (!rat.tryDepositItemInContainers(burntItem) && !rat.m_9236_().m_5776_()) {
                    rat.m_5552_(burntItem, 0.25f);
                }
                rat.cookingProgress = 0;
            }
        }
    }
}

