/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.StatBoostingRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesOverlayUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.DamageImmunityUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.GlowingEyesUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.PostAttackUpgrade;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DemonRatUpgradeItem
extends StatBoostingRatUpgradeItem
implements GlowingEyesUpgrade,
DamageImmunityUpgrade,
PostAttackUpgrade,
ChangesOverlayUpgrade {
    public DemonRatUpgradeItem(Item.Properties properties) {
        super(properties, 1, 2, () -> Map.of(Attributes.f_22276_, RatConfig.demonHealthUpgrade, Attributes.f_22281_, RatConfig.demonDamageUpgrade), false);
    }

    public static boolean isSoulVersion(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Soul");
    }

    public static ItemStack getDemonUpgrade(boolean soul) {
        ItemStack stack = new ItemStack((ItemLike)RatsItemRegistry.RAT_UPGRADE_DEMON.get());
        stack.m_41784_().m_128379_("Soul", soul);
        return stack;
    }

    @Override
    public RenderType getEyeTexture(ItemStack stack) {
        if (DemonRatUpgradeItem.isSoulVersion(stack)) {
            return RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/demon_rat/soul_demon_rat_eye.png"));
        }
        return RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/demon_rat/demon_rat_eye.png"));
    }

    @Override
    public boolean isImmuneToDamageSource(TamedRat rat, DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268745_);
    }

    @Override
    public void afterHit(TamedRat rat, LivingEntity target) {
        if (!target.m_5825_()) {
            target.m_20254_(10);
        }
    }

    @Override
    @Nullable
    public RenderType getOverlayTexture(ItemStack stack, TamedRat rat, float partialTicks) {
        if (DemonRatUpgradeItem.isSoulVersion(stack)) {
            return RenderType.m_110476_((ResourceLocation)new ResourceLocation("rats", "textures/entity/demon_rat/soul_demon_rat.png"));
        }
        return RenderType.m_110476_((ResourceLocation)new ResourceLocation("rats", "textures/entity/demon_rat/demon_rat.png"));
    }
}

