/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.mount;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class RatStriderMount
extends RatMountBase {
    private static final UUID SUFFOCATING_MODIFIER_UUID = UUID.fromString("9e362924-01de-4ddd-a2b2-d0f7a405a174");
    private static final AttributeModifier SUFFOCATING_MODIFIER = new AttributeModifier(SUFFOCATING_MODIFIER_UUID, "Strider suffocating modifier", (double)-0.34f, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_SUFFOCATING = SynchedEntityData.m_135353_(RatStriderMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RatStriderMount(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.175f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_SUFFOCATING, (Object)false);
    }

    public void setSuffocating(boolean suffocating) {
        this.f_19804_.m_135381_(DATA_SUFFOCATING, (Object)suffocating);
        AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
        if (attribute != null) {
            attribute.m_22120_(SUFFOCATING_MODIFIER_UUID);
            if (suffocating) {
                attribute.m_22118_(SUFFOCATING_MODIFIER);
            }
        }
    }

    public boolean isSuffocating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SUFFOCATING);
    }

    public boolean m_203441_(FluidState p_204067_) {
        return p_204067_.m_205070_(FluidTags.f_13132_);
    }

    @Override
    public double m_6048_() {
        float f = Math.min(0.25f, this.f_267362_.m_267731_());
        float f1 = this.f_267362_.m_267756_();
        return (double)this.m_20206_() - 0.1 + (double)(0.12f * Mth.m_14089_((float)(f1 * 1.5f)) * 2.0f * f);
    }

    protected float m_245547_(Player player) {
        return (float)(this.m_21133_(Attributes.f_22279_) * (this.isSuffocating() ? 0.35 : 0.55));
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.6f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.m_20077_() ? SoundEvents.f_12464_ : SoundEvents.f_12463_, 1.0f, 1.0f);
    }

    protected void m_7840_(double yDistance, boolean onGround, BlockState state, BlockPos pos) {
        this.m_20101_();
        if (this.m_20077_()) {
            this.m_183634_();
        } else {
            super.m_7840_(yDistance, onGround, state, pos);
        }
    }

    public void m_8119_() {
        if (!this.m_21525_()) {
            BlockState blockstate = this.m_9236_().m_8055_(this.m_20183_());
            BlockState blockstate1 = this.m_20075_();
            boolean flag = blockstate.m_204336_(BlockTags.f_13086_) || blockstate1.m_204336_(BlockTags.f_13086_) || this.getFluidTypeHeight((FluidType)ForgeMod.LAVA_TYPE.get()) > 0.0;
            this.setSuffocating(!flag);
        }
        super.m_8119_();
        this.floatStrider();
        this.m_20101_();
    }

    private void floatStrider() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12458_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12462_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12461_;
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    protected PathNavigation m_6037_(Level level) {
        return new StriderPathNavigation(this, level);
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        if (reader.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13132_)) {
            return 10.0f;
        }
        return this.m_20077_() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Override
    public Item getUpgradeItem() {
        return (Item)RatsItemRegistry.RAT_UPGRADE_STRIDER_MOUNT.get();
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, 1.0f, 0.0f, 0.0f, 20.0f);
        this.progressRotation(lowerTail, rat.sitProgress, -0.1f, 0.0f, 0.0f, 20.0f);
    }

    static class StriderPathNavigation
    extends GroundPathNavigation {
        StriderPathNavigation(RatStriderMount strider, Level level) {
            super((Mob)strider, level);
        }

        protected boolean m_7367_(BlockPathTypes types) {
            return types == BlockPathTypes.LAVA || types == BlockPathTypes.DAMAGE_FIRE || types == BlockPathTypes.DANGER_FIRE || super.m_7367_(types);
        }

        public boolean m_6342_(BlockPos pos) {
            return this.f_26495_.m_8055_(pos).m_60713_(Blocks.f_49991_) || super.m_6342_(pos);
        }
    }
}

