/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.registry.RatsEffectRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.monster.boss.BlackDeath;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlagueCloud
extends Monster {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(PlagueCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public PlagueCloud(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21342_ = new AIMoveControl(this);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.PLAGUE_CLOUD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.PLAGUE_CLOUD_DEATH.get();
    }

    public void m_8107_() {
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_20242_(true);
        double d0 = this.f_20916_ > 0 ? 1.0 : 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
        double y = this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()) - (double)this.m_20206_();
        double z = this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
        float f = (this.m_20205_() + this.m_20206_() + this.m_20205_()) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            if (this.m_217043_().m_188499_()) {
                this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.BLACK_DEATH.get(), x, y + 1.5, z, d0, d1, d2);
            } else {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, x, y + 1.5, z, d0, d1, d2);
            }
        }
        if (this.getOwnerId() != null && this.getOwner() != null && (livingEntity = this.getOwner()) instanceof BlackDeath) {
            BlackDeath death = (BlackDeath)livingEntity;
            if (death.m_5448_() != null && death.m_5448_().m_6084_()) {
                this.m_6710_(death.m_5448_());
            } else {
                float radius = 9.0f - (float)Math.sin((double)death.f_19797_ * 0.4) * 0.25f;
                int maxRatStuff = 360 / Math.max(death.getCloudsSummoned(), 1);
                int ratIndex = this.m_19879_() % Math.max(death.getCloudsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.f_19797_ * 4.1f);
                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + death.m_20185_();
                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + death.m_20189_();
                this.m_21566_().m_6849_(extraX, death.m_20186_() + 2.0 + (double)this.m_217043_().m_188503_(2), extraZ, 1.0);
            }
        }
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        LivingEntity livingEntity;
        if (!this.m_6084_() && this.getOwnerId() != null && this.getOwner() != null && (livingEntity = this.getOwner()) instanceof BlackDeath) {
            BlackDeath death = (BlackDeath)livingEntity;
            if (RatConfig.bdConstantCloudSpawns) {
                death.setCloudsSummoned(death.getCloudsSummoned() - 1);
            }
        }
        super.m_142687_(reason);
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.m_20185_() - toX;
        double d1 = this.m_20186_() - toY;
        double d2 = this.m_20189_() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AIMeleeAttack(this));
        this.f_21345_.m_25352_(8, (Goal)new AIMoveRandom());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance((MobEffect)RatsEffectRegistry.PLAGUE.get(), 600));
        }
        return flag;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_142535_(float dist, float mult, DamageSource source) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() == null) {
            compound.m_128359_("OwnerUUID", "");
        } else {
            compound.m_128359_("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.m_20088_().m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.m_20088_().m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            Entity entity;
            Player player;
            UUID uuid = this.getOwnerId();
            Player player2 = player = uuid == null ? null : this.m_9236_().m_46003_(uuid);
            if (player != null) {
                return player;
            }
            if (!this.m_9236_().m_5776_() && (entity = this.m_9236_().m_7654_().m_129880_(this.m_9236_().m_46472_()).m_8791_(uuid)) instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public boolean m_7307_(Entity entity) {
        return super.m_7307_(entity) || entity.m_6095_().m_204039_(RatsEntityTags.PLAGUE_LEGION);
    }

    class AIMoveControl
    extends MoveControl {
        public AIMoveControl(PlagueCloud cloud) {
            super((Mob)cloud);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                double edgeLength;
                Vec3 vec3d = new Vec3(this.m_25000_() - PlagueCloud.this.m_20185_(), this.m_25001_() - PlagueCloud.this.m_20186_(), this.m_25002_() - PlagueCloud.this.m_20189_());
                double d0 = vec3d.m_82553_();
                if (d0 < (edgeLength = PlagueCloud.this.m_20191_().m_82309_())) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    PlagueCloud.this.m_20256_(PlagueCloud.this.m_20184_().m_82490_(0.5));
                } else {
                    PlagueCloud.this.m_20256_(PlagueCloud.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.1 / d0)));
                    if (PlagueCloud.this.m_5448_() == null) {
                        Vec3 vec3d1 = PlagueCloud.this.m_20184_();
                        PlagueCloud.this.m_146922_(-((float)Mth.m_14136_((double)vec3d1.f_82479_, (double)vec3d1.f_82481_)) * 57.295776f);
                    } else {
                        double d4 = PlagueCloud.this.m_5448_().m_20185_() - PlagueCloud.this.m_20185_();
                        double d5 = PlagueCloud.this.m_5448_().m_20189_() - PlagueCloud.this.m_20189_();
                        PlagueCloud.this.m_146922_(-((float)Mth.m_14136_((double)d4, (double)d5)) * 57.295776f);
                    }
                    PlagueCloud.this.f_20883_ = PlagueCloud.this.m_146908_();
                }
            }
        }
    }

    class AIMeleeAttack
    extends Goal {
        private final PlagueCloud parentEntity;
        public int attackTimer;

        public AIMeleeAttack(PlagueCloud ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8037_() {
            LivingEntity living = this.parentEntity.m_5448_();
            if (living != null && living.m_20280_((Entity)this.parentEntity) >= 2.0 || !this.parentEntity.m_142582_((Entity)living)) {
                PlagueCloud.this.m_21566_().m_6849_(living.m_20185_(), living.m_20186_() + 1.0, living.m_20189_(), 0.5);
            }
            if (living.m_20280_((Entity)this.parentEntity) < 5.0) {
                ++this.attackTimer;
                if (this.attackTimer == 5) {
                    this.parentEntity.m_7327_((Entity)living);
                    this.attackTimer = -10;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !PlagueCloud.this.m_21566_().m_24995_() && PlagueCloud.this.m_217043_().m_188503_(2) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = PlagueCloud.this.m_20183_();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(PlagueCloud.this.m_217043_().m_188503_(15) - 7, PlagueCloud.this.m_217043_().m_188503_(11) - 5, PlagueCloud.this.m_217043_().m_188503_(15) - 7);
                if (!PlagueCloud.this.m_9236_().m_46859_(blockpos1)) continue;
                PlagueCloud.this.m_21566_().m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (PlagueCloud.this.m_5448_() != null) break;
                PlagueCloud.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

