/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IForgeShearable;

public class RatUseShearsGoal
extends BaseRatHarvestGoal {
    private static final ItemStack SHEAR_STACK = new ItemStack((ItemLike)Items.f_42574_);
    private final TamedRat rat;
    private final Predicate<LivingEntity> SHEAR_PREDICATE = entity -> entity instanceof IForgeShearable && ((IForgeShearable)entity).isShearable(SHEAR_STACK, entity.m_9236_(), entity.m_20183_());

    public RatUseShearsGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || !this.checkTheBasics(this.rat.getDepositPos().isPresent(), this.rat.getDepositPos().isPresent())) {
            return false;
        }
        this.resetTarget();
        return this.getTargetEntity() != null || this.getTargetBlock() != null;
    }

    public boolean m_8045_() {
        return this.getTargetEntity() != null || this.getTargetBlock() != null;
    }

    public void m_8037_() {
        if (this.getTargetEntity() != null && this.getTargetEntity().m_6084_() && this.rat.m_21205_().m_41619_()) {
            this.rat.m_21573_().m_5624_(this.getTargetEntity(), 1.25);
            if (this.rat.m_20280_(this.getTargetEntity()) < this.rat.getRatHarvestDistance(0.0)) {
                Entity entity = this.getTargetEntity();
                if (entity instanceof IForgeShearable) {
                    IForgeShearable shearable = (IForgeShearable)entity;
                    List drops = shearable.onSheared(null, SHEAR_STACK, this.rat.m_9236_(), this.getTargetEntity().m_20183_(), 0);
                    this.rat.m_146850_(GameEvent.f_223708_);
                    for (ItemStack stack : drops) {
                        this.getTargetEntity().m_5552_(stack, 0.0f);
                    }
                }
                this.m_8041_();
            }
        } else if (this.getTargetBlock() != null && this.rat.m_21205_().m_41619_()) {
            this.rat.m_21573_().m_26519_((double)this.getTargetBlock().m_123341_() + 0.5, (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_() + 0.5, 1.25);
            if (this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_()) < this.rat.getRatHarvestDistance(0.0)) {
                BlockState state = this.rat.m_9236_().m_8055_(this.getTargetBlock());
                this.rat.m_9236_().m_5594_(null, this.rat.m_20183_(), SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
                BeehiveBlock.m_49600_((Level)this.rat.m_9236_(), (BlockPos)this.getTargetBlock());
                this.rat.m_146850_(GameEvent.f_157781_);
                if (!CampfireBlock.m_51248_((Level)this.rat.m_9236_(), (BlockPos)this.getTargetBlock())) {
                    if (this.hiveContainsBees(this.rat.m_9236_(), this.getTargetBlock())) {
                        this.angerNearbyBees(this.rat.m_9236_(), this.getTargetBlock());
                    }
                    this.releaseBeesAndResetHoneyLevel(this.rat.m_9236_(), state, this.getTargetBlock(), BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                } else {
                    this.rat.m_9236_().m_7731_(this.getTargetBlock(), (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
                }
                this.m_8041_();
            }
        } else {
            this.m_8041_();
        }
    }

    private void angerNearbyBees(Level level, BlockPos pos) {
        List list = level.m_45976_(Bee.class, new AABB(pos).m_82377_(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            for (Bee bee : list) {
                if (bee.m_5448_() != null) continue;
                bee.m_6710_((LivingEntity)this.rat);
            }
        }
    }

    private boolean hiveContainsBees(Level level, BlockPos pos) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehiveblockentity = (BeehiveBlockEntity)blockentity;
            return !beehiveblockentity.m_58774_();
        }
        return false;
    }

    public void releaseBeesAndResetHoneyLevel(Level level, BlockState state, BlockPos pos, BeehiveBlockEntity.BeeReleaseStatus status) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehive = (BeehiveBlockEntity)blockentity;
            List list = beehive.m_58759_(state, status);
            for (Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(this.rat.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                if (!beehive.m_58777_()) {
                    bee.m_6710_((LivingEntity)this.rat);
                    continue;
                }
                bee.m_27915_(400);
            }
        }
    }

    private void resetTarget() {
        int radius = this.rat.getRadius();
        AABB bb = new AABB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).m_82338_(this.rat.getSearchCenter());
        List list = this.rat.m_9236_().m_6443_(LivingEntity.class, bb, this.SHEAR_PREDICATE);
        LivingEntity closestSheep = null;
        for (LivingEntity base : list) {
            if (closestSheep != null && !(base.m_20280_((Entity)this.rat) < closestSheep.m_20280_((Entity)this.rat))) continue;
            closestSheep = base;
        }
        if (closestSheep != null) {
            this.setTargetEntity((Entity)closestSheep);
            return;
        }
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.rat.getRadius();
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
            if (!(this.rat.m_9236_().m_8055_(pos).m_60734_() instanceof BeehiveBlock) || (Integer)this.rat.m_9236_().m_8055_(pos).m_61143_((Property)BeehiveBlock.f_49564_) != 5) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.getTargetSorter());
            this.setTargetBlock((BlockPos)allBlocks.get(0));
        }
    }
}

